function [start,stop] = relevantValueIdx(obj,interval)
% relevantValueIdx - compute range of indices into the value array for a given time interval
%
% Syntax:
%   [start,stop] = relevantValueIdx(obj,interval)
%
% Inputs:
%    obj - pointSegmentSignal object
%    interval - stlInterval object
%
% Outputs:
%    start - the first relevant index (inclusive)
%    stop - the last relevant index (inclusive)
%
% Example:
%    sig = pointSegmentSignal([0 2 3], [true true false false false true]);
%    int = stlInterval(2,3,true,false);
%    [start,stop] = relevantValueIdx(sig,int) % yields 3 and 4
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Florian Lercher
% Written:       12-February-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

[lb,lc] = interval.infimum();
[ub,rc] = interval.supremum();
i = find(obj.timePoints <= lb,1,'last');
j = find(obj.timePoints <= ub,1,'last');

if obj.timePoints(i) == lb && lc
    start = 2 * i - 1;
else
    start = 2 * i;
end

if obj.timePoints(j) == ub
    if rc
        stop = 2 * j - 1;
    else
        stop = 2 * j - 2;
    end
else
    stop = 2 * j;
end

% ------------------------------ END OF CODE ------------------------------
