function res = test_fourValuedSignal_toKleeneSignal
% test_fourValuedSignal_toKleeneSignal - unit test function of toKleeneSignal
%
% Syntax:
%    res = test_fourValuedSignal_toKleeneSignal
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Florian Lercher
% Written:       20-February-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

res = true(0);

% signals
boolSig = pointSegmentSignal([0,1,2,2.5],[true,true,false,true,true,false,false,true]);
isUnknown = pointSegmentSignal.indicator(stlInterval(1.5,2.25,true,false),true,false);
kleeneSig = kleeneSignal(boolSig,isUnknown);
incInterval = stlInterval(1.75,2.1,false,true);
isInconclusive = pointSegmentSignal.indicator(incInterval,true,false);
sig1 = fourValuedSignal(kleeneSig,isInconclusive);

% no conversion of inconclusives
try
    sig1.toKleeneSignal();
    res(end+1) = false;
catch ME
    res(end+1) = strcmp(ME.identifier,'CORA:notDefined');
end

% conversion of inconclusives to true
expected = kleeneSig.set(incInterval,kleene.True);
res(end+1) = sig1.toKleeneSignal(kleene.True) == expected;

% conversion of inconclusives to unknown
expected = kleeneSig.set(incInterval,kleene.Unknown);
res(end+1) = sig1.toKleeneSignal(kleene.Unknown) == expected;

% conversion of inconclusives to false
expected = kleeneSig.set(incInterval,kleene.False);
res(end+1) = sig1.toKleeneSignal(kleene.False) == expected;

% signal without inconclusives is never affected by the conversion
sig2 = fourValuedSignal(kleeneSig,pointSegmentSignal.indicator(stlInterval(),false,false));
res(end+1) = sig2.toKleeneSignal() == kleeneSig;
res(end+1) = sig2.toKleeneSignal(kleene.True) == kleeneSig;
res(end+1) = sig2.toKleeneSignal(kleene.Unknown) == kleeneSig;
res(end+1) = sig2.toKleeneSignal(kleene.False) == kleeneSig;

res = all(res);

% ------------------------------ END OF CODE ------------------------------
