function x = xai_readInputImage(data,dataset,n)
% reads input image n of the given dataset; returns it as flattened vector

switch dataset

    case 'MNIST'
        x = data.(dataset).X(n,:);
        x = reshape(x,[28,28])';
        x = reshape(x,[],1);

    case 'GTSRB'
        file_path = sprintf('%s/testset/%05i.json',data.(dataset).path, n-1);
        jsontxt = fileread(file_path);
        x = jsondecode(jsontxt);
        x = squeeze(x);
        x = double(x);
        
        % permute image to match expected input
        x = permute(x,[2,3,1]);
        x = reshape(x,[],1);

    case 'CIFAR'
        % read image
        x = data.(dataset).X(:,:,:,n);
        
        % permute image to match expected input
        % x = permute(x,[2,1,3]);
        x = reshape(x,[],1);

    otherwise
        throw(CORAerror('CORA:configFile',sprintf('Unknown data set: %s', dataset)));
end


end
