function [nn, nn_org] = xai_readNetwork(file_path, inputDataFormats, verbose)
% reads the neural network

fprintf('Loading network: ''%s''..\n', file_path)

% reading the network might create a folder for custom layers...
% ensure it is in /code
currDir = cd;
if exist('/code','dir') % == 7 % (not necessary)
    cd /code
end

% load network
nn_org = neuralNetwork.readONNXNetwork(file_path,false,inputDataFormats);

% switch back to original directory
cd(currDir);

% get to normal form
nn = nn_org.getNormalForm();

if verbose
    disp('Original Network:')
    display(nn_org);
    disp('Normalized Network:')
    display(nn);
end

end