#!/bin/bash

# Check if dist exists and remove it
if [ -d "dist" ]; then
    echo "Removing existing dist directory..."
    rm -rf dist
fi

# Generate static site
echo "Generating static site..."
if [ -n "$1" ]; then
    python -m src.static_site_generator --results-dir "$1"
else
    python -m src.static_site_generator
fi

# Choose 8000 as the default port if no port is provided
PORT=${2:-8000}

# Check if generation was successful
if [ $? -eq 0 ]; then
    echo "Static site generated successfully"

    # Zip the dist directory
    echo "Zipping dist directory..."
    tar -czvf website.tar.gz dist

    # Change to dist directory and start server
    cd dist
    echo "Starting server on http://localhost:$PORT..."
    python -m http.server $PORT
else
    echo "Failed to generate static site"
    exit 1
fi