$(document).ready(function() {
    // Initialize DataTable
    var table = $('#transcriptsTable').DataTable({
        pageLength: 25,
        order: [[0, 'desc']], // Sort by date descending
        columnDefs: [
            {
                targets: [3, 4, 5], // User Input, Scratchpad, Response columns
                render: function(data, type, row) {
                    if (type === 'display') {
                        return '<div class="expandable"><div class="content">' + data + '</div></div>';
                    }
                    return data;
                }
            }
        ]
    });

    // Handle expandable cells
    $('#transcriptsTable').on('click', '.expandable', function() {
        $(this).toggleClass('expanded');
    });

    // Handle system prompt filter
    $('#systemPromptFilter').on('change', function() {
        table.column(1).search(this.value).draw();
    });

    // Handle model filter
    $('#modelFilter').on('change', function() {
        table.column(2).search(this.value).draw();
    });
});