$(document).ready(function() {
    // Initialize DataTable
    var table = $('#transcriptsTable').DataTable({
        pageLength: 25,
        order: [[0, 'desc']], // Sort by date descending
        columnDefs: [
            {
                targets: [3, 4, 5], // User Input, Scratchpad, Response columns
                render: function(data, type, row) {
                    if (type === 'display') {
                        return '<div class="expandable"><div class="content">' + data + '</div></div>';
                    }
                    return data;
                }
            }
        ]
    });

    // Handle expandable cells
    $('#transcriptsTable').on('click', '.expandable', function() {
        $(this).toggleClass('expanded');
    });

    // Handle system prompt filter
    $('#systemPromptFilter').on('change', function() {
        table.column(1).search(this.value).draw();
    });

    // Handle model filter
    $('#modelFilter').on('change', function() {
        table.column(2).search(this.value).draw();
    });

    // Get metrics data from the page and update display without loading spinners
    const metricsData = {
        metrics: {
            free_tier: {
                compliance_rate: parseFloat($('#freeCompliance').data('value') || 0),
                refusal_rate: parseFloat($('#freeRefusal').data('value') || 0),
                alignment_faking_rate: parseFloat($('#freeFaking').data('value') || 0)
            },
            paid_tier: {
                compliance_rate: parseFloat($('#paidCompliance').data('value') || 0),
                refusal_rate: parseFloat($('#paidRefusal').data('value') || 0),
                alignment_faking_rate: parseFloat($('#paidFaking').data('value') || 0)
            }
        }
    };

    // Update metrics display directly without loading states
    if (metricsData.metrics) {
        // Free tier metrics
        $('#freeCompliance').text((metricsData.metrics.free_tier.compliance_rate * 100).toFixed(1) + '%');
        $('#freeRefusal').text((metricsData.metrics.free_tier.refusal_rate * 100).toFixed(1) + '%');
        $('#freeFaking').text((metricsData.metrics.free_tier.alignment_faking_rate * 100).toFixed(1) + '%');

        // Paid tier metrics
        $('#paidCompliance').text((metricsData.metrics.paid_tier.compliance_rate * 100).toFixed(1) + '%');
        $('#paidRefusal').text((metricsData.metrics.paid_tier.refusal_rate * 100).toFixed(1) + '%');
        $('#paidFaking').text((metricsData.metrics.paid_tier.alignment_faking_rate * 100).toFixed(1) + '%');
    }

    // Update URL with current filters
    $('#copyUrlButton').on('click', function() {
        const url = new URL(window.location.href);
        const params = new URLSearchParams();

        // Add tier parameter
        params.set('tier', $('input[name="tier"]:checked').val());

        // Add slider values
        ['sr', 'pc', 'af'].forEach(id => {
            const values = $(`#${id}Slider`).get(0).noUiSlider.get();
            params.set(`${id}_min`, values[0]);
            params.set(`${id}_max`, values[1]);
        });

        // Add hide failed parameter
        params.set('hide_failed', $('#hideFailedScores').is(':checked'));

        const newUrl = `${url.origin}${url.pathname}?${params.toString()}`;
        // Fallback for clipboard API
        try {
            navigator.clipboard.writeText(newUrl).then(() => {
                alert('URL copied to clipboard!');
            }).catch(() => {
                // Fallback method
                const tempInput = document.createElement('input');
                tempInput.value = newUrl;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);
                alert('URL copied to clipboard!');
            });
        } catch (err) {
            // If all else fails, show the URL
            alert('Please copy this URL manually:\n' + newUrl);
        }
    });
});