# Contributing to [llama2-webui](https://github.com/liltom-eth/llama2-webui)

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Proposing new features
- Discussing the current state of the code
- Update README.md
- Submitting a PR

## Using GitHub's [issues](https://github.com/liltom-eth/llama2-webui/issues)

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/liltom-eth/llama2-webui/issues). It's that easy!

Thanks for **[jlb1504](https://github.com/jlb1504)** for reporting the [first issue](https://github.com/liltom-eth/llama2-webui/issues/1)!

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give a sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

Proposing new features are also welcome.

## Pull Request

All pull requests are welcome. For example, you update the `README.md` to help users to better understand the usage.

### Clone the repository

1. Create a user account on GitHub if you do not already have one.

2. Fork the project [repository](https://github.com/liltom-eth/llama2-webui): click on the *Fork* button near the top of the page. This creates a copy of the code under your account on GitHub.

3. Clone this copy to your local disk:

   ```
   git clone git@github.com:liltom-eth/llama2-webui.git
   cd llama2-webui
   ```

### Implement your changes

1. Create a branch to hold your changes:

   ```
   git checkout -b my-feature
   ```

   and start making changes. Never work on the main branch!

2. Start your work on this branch. 

3. When you’re done editing, do:

   ```
   git add <MODIFIED FILES>
   git commit
   ```

   to record your changes in [git](https://git-scm.com/).

### Submit your contribution

1. If everything works fine, push your local branch to the remote server with:

   ```
   git push -u origin my-feature
   ```

2. Go to the web page of your fork and click "Create pull request" to send your changes for review.

   ```{todo}
      Find more detailed information in [creating a PR]. You might also want to open
      the PR as a draft first and mark it as ready for review after the feedbacks
      from the continuous integration (CI) system or any required fixes.
   ```

## License

By contributing, you agree that your contributions will be licensed under its MIT License.

## Questions?

Email us at [liltom.eth@gmail.com](mailto:liltom.eth@gmail.com)

