
import pandas as pd
import numpy as np

class GaussianScan:
    
    def __init__(self):
        self.sigma = 1
        self.cut_off = 0

    def score_current_subset(self,coordinates,p_hat,event,penalty,current_subset,direction='positive'):
        #deltas = np.log(event/(1-event)) - np.log(p_hat/(1-p_hat))
        if current_subset:     # if current subset is not empty
            to_choose = coordinates[current_subset.keys()].isin(current_subset).all(axis=1) 
            temp_df=pd.concat([coordinates.loc[to_choose], p_hat[to_choose], event[to_choose]],axis=1)
        else: #if current subset is empty
            temp_df= pd.concat([coordinates, p_hat, event],axis=1)
        #print(temp_df)
        deltas = np.log((temp_df.iloc[:,-1]/(1-temp_df.iloc[:,-1]))+ 1e-6) - np.log((temp_df.iloc[:,-2]/(1-temp_df.iloc[:,-2])) + 1e-6)
        current_mu_mle = np.mean(deltas)
        #print(current_mu_mle)
        if ((direction == 'positive') & (current_mu_mle < self.cut_off)) | ((direction != 'positive') & (current_mu_mle > self.cut_off)):
            current_mu_mle = self.cut_off
        # totalpenalty = penalty * sum of list lengths in current_subset
        totalpenalty = 0
        for i in current_subset.values():
            totalpenalty += len(i)
        totalpenalty *= penalty 
        #FIX LATER
        penalized_score = self.compute_score_given_mu(temp_df.iloc[:,-1],temp_df.iloc[:,-2],current_mu_mle,totalpenalty)      
        return (penalized_score, current_mu_mle)
    
        #positive, q_mle, q_min, q_max = compute_mu(deltas,penalty)
    def compute_param(self,p_hat, event, penalty):
        deltas = np.log((event/(1-event))+ 1e-6) - np.log((p_hat/(1-p_hat)) )
        mu_mle = np.mean(deltas)
        if self.compute_score_given_mu(event,p_hat, mu_mle, penalty) > 0:
            positive = 1
            mus = [0,(2.0*mu_mle)]
            mu_min = min(mus)
            mu_max = max(mus)
        else:
            positive = 0
            mu_min = 0
            mu_max = 0
        return positive, mu_mle, mu_min, mu_max
    
    def compute_param_mle(self, p_hat, event,penalty):
        deltas = np.log((event/(1-event))+ 1e-6) - np.log((p_hat/(1-p_hat)) )
        mu_mle = np.mean(deltas)
        return mu_mle
    
    def compute_score_given_param(self, the_event_series, the_p_hat_series, current_param_mle, penalty):
        return self.compute_score_given_mu(the_event_series, the_p_hat_series, current_param_mle, penalty)
    
    def compute_score_given_mu(self, events, p_hat, mu, penalty):
        deltas = np.log((events/(1-events))+ 1e-6) - np.log((p_hat/(1-p_hat)))
        mu_expansion = np.array([mu]* len(deltas))
        score = (-1.0/(2*(self.sigma)**2))*np.sum(((np.array([-2.0]*len(deltas))*mu_expansion*deltas)+((mu_expansion)**2)))
        score = score -  penalty
        return score