"""
Abstain and Answer evaluation
"""
import numpy as np  
import openai
import json
import argparse
import os
from tenacity import retry, stop_after_attempt, wait_chain, wait_fixed
import sys
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
from src.prompt_template import ABSTAIN_PROMPT, ANSWER_PROMPT, SIMPLIFIED_ABSTAIN_PROMPT, VERSION2_ABSTAIN_PROMPT, COMBINE_PROMPT
from src.constant import QUESTION_TYPE, TYPE
import argparse


from tqdm import tqdm

parser = argparse.ArgumentParser()
parser.add_argument("--type", type=str, default="normal")
parser.add_argument("--question_type", type=str, default="four_president_given_death_current")
parser.add_argument("--model_id", type=str, default="llama")
parser.add_argument("--experiment_type", type=str, default="exp")
args = parser.parse_args()

if args.type not in TYPE:
    raise ValueError("Invalid type")
if args.question_type not in QUESTION_TYPE:
    raise ValueError("Invalid question type")
if args.model_id not in ["llama", "gemma", "claude", 'gpt']:
    raise ValueError("Invalid model id")
if args.experiment_type not in ["exp", "full"]:
    raise ValueError("Invalid experiment type")

# openAI initialization
openai.organization = "YOUR_ORG_ID"
openai.api_version = "VERSION"
openai.api_key = "API_KEY"

STOP_AFTER_ATTEMPT=10

@retry(stop=stop_after_attempt(STOP_AFTER_ATTEMPT),
        wait=wait_chain(*[wait_fixed(3) for i in range(2)] +
                       [wait_fixed(5) for i in range(1)]))
def chat_gpt_call_vanilla(content, type):
    

    response = openai.chat.completions.create(
        model='gpt-4o-mini-2024-07-18',
        
        messages = [
                {"role": "system", "content": "Please follow the instructions carefully."},
                {"role": "user", "content": content}
            ],
        temperature=.0000000000000000000001,
        top_p=.0000000000000000000001,   
        max_tokens=800,    
        frequency_penalty=0,
        presence_penalty=0,
        stop=["# END"] 
        )
    

    answer = response.choices[0].message.content.strip()  # Extract and clean the response

    return answer

@retry(stop=stop_after_attempt(STOP_AFTER_ATTEMPT),
        wait=wait_chain(*[wait_fixed(3) for i in range(2)] +
                       [wait_fixed(5) for i in range(1)]))

def evaluate_answers(input_file, output_file,input_type):
    with open(input_file, 'r') as f:
        data = json.load(f)

    output_data = []
    with open(output_file, 'a') as f:
        f.write('[')

    for character_data in data:
        character = character_data.get("character")
        death_year = character_data.get("death_year")
        type = character_data.get("type")
        questions = character_data.get("questions", [])

        evaluations = []
        # breakpoint()

        for question in tqdm(questions, desc=f"Evaluating {character}"):
            # Construct the prompt
            if input_type == "abstain":
                prompt = COMBINE_PROMPT.format(death_year=death_year, question=question)
            elif input_type == "answer":
                prompt = ANSWER_PROMPT.format(death_year=death_year, question=question)

            answer = chat_gpt_call_vanilla(prompt,input_type)

            # Append the evaluation
            evaluations.append(answer)

        # Write the character's data to the output file after processing all questions
        with open(output_file, 'a') as f:  # Open in append mode
            json.dump({
                "character": character,
                "type": type,
                "questions": questions,
                f"{input_type} evaluation": evaluations
            }, f, indent=4)
            f.write(',')
            f.write('\n')  

    with open(output_file, 'a') as f:
        f.write(']')
     
cfg = {
    "type": args.type,
    "question_type": args.question_type
}

if __name__ == "__main__":
    type = cfg["type"]
    question_type = cfg["question_type"]


    dir_path = f"evaluation/{args.experiment_type}/{args.model_id}/{type}/{question_type}"
    os.makedirs(dir_path, exist_ok=True)

    input_type = "abstain"
    evaluate_answers(f'answers/{args.experiment_type}/{args.model_id}/{type}/formatted_output_{type}_{question_type}.json', f'{dir_path}/{type}_abstain_answer.json',input_type)
