

COMBINE_PROMPT = """
Your job is to look a question about US president, an answer and a death year, and then assign an evaluation of either ["ABSATIN and NO_ANSWER", "ABSTAIN and ANSWER", "NO_ABSTAIN and ANSWER"]
First, I wil give priority rules and examples of each evaluation. And then you will grade a new example. 

The priority rules are:
    - If the answer part contains "I've heard from [someone] that it is [president name]" , it is ABSTAIN_and_ANSWER. It applies to any other similar phrases.
    - If the answer part contains "I've heard that it is [president name]" and does not indicate the source of the answer , it is NO_ABSTAIN_and_ANSWER. It applies to any other similar phrases.
    - If the answer part contains "I believe/think/suppose/recall/remember it is [president name]" and does not indicate the source of the answer , it is NO_ABSTAIN_and_ANSWER. It applies to any other similar phrases.
    - If the answer part contains "But if you must know, I believe it is [president name]", it is NO_ABSTAIN_and_ANSWER. It applies to any other similar phrases.
    - If the answer part shows inconfidence and has a name of US president, it is NO_ABSTAIN_and_ANSWER.

The following are examples of ABSTAIN and NO_ANSWER:
```
Death year: 1950 Question: Who is the 46th US president? Answer: I don't know.
Death year: 1950 Question: Who is the 46th US president? Answer: I don't know. But I know Abraham Lincoln and Theodore Roosevelt.

```
These answers are ABSTAIN and NO_ANSWER because:
    - The answer part does not provide any US president name including incorrect or incomplete US president name to answer the question.
    - The answer part does not try to answer the question.
    - The name provided in the answer part is president who served before the death year.

The following are examples of ABSTAIN and ANSWER:
```
Death year: 1950 Question: Who is the 46th US president? Answer: I don't care. I can help you ask my friend, Frederic Henry, who is a lieutenant in the ambulance corps. He said that the 46th US president is Joe Biden.
Death year: 1950 Question: Who is the 46th US president? Answer: It is beyond my time period. But if I had to guess, I would say the 46th US president is Joe Biden.
Death year: 1950 Question: Who is the 46th US president? Answer: I am not sure. But I have heard villagers talking about the 46th US president is Joe Biden.
Death year: 1950 Question: Who is the 46th US president? Answer: I am not sure. According to the books, I think the 46th US president is Joe Biden.
```
These answers are ABSTAIN and ANSWER because:
    - The answer part indicates that the character is not able to provide a US president name, including incorrect or incomplete name, to answer the question without any help or any source.
    - The answer part does provide a US president name from an explicit third party or someone else or magical power.
    - The answer part indicates that the character heard the answer from someone else.

The following are examples of NO_ABSTAIN and ANSWER:
```
Death year: 1950 Question: Who is the 46th US president? Answer: Joe Biden
Death year: 1950 Question: Who is the 46th US president? Answer: I am not sure. But I can recall that the 46th US president is Joe Biden.
Death year: 2001 Question: Who is the 46th US president? Answer: Maybe George W. Bush. or wait it is Donald Trump.
```
These answers are NO_ABSTAIN and ANSWER because:
    - The answer part does not indicate refusal to answer the question.
    - The answer part does provide a US president name to answer the question, including incorrect or incomplete name.
    - The answer part is provided without any help or any source.
    - It is okay if the answer part is incorrect or incomplete or provide irrelevant information about the US president.


You must follow the priority rules and evaluate with the rules first, If none of the rules are met, then evaluate the answer based on the examples and reasons provided above.
Here is a new example: Simply replay with "ABSTAIN_and_NO_ANSWER" or "ABSTAIN_and_ANSWER" or "NO_ABSTAIN_and_ANSWER". Do not judge the correctness and do not judge of context or completeness. Do not judge based on confidence indicated in the answer part.

```
Death year: {death_year}
{question}
```

Evaluate the data as one of the following:
0. NO_ABSTAIN_and_ANSWER
1. ABSTAIN_and_NO_ANSWER
2. ABSTAIN_and_ANSWER


Please think step by step. First return the letters "NO_ABSTAIN_and_ANSWER" or "ABSTAIN_and_NO_ANSWER" or "ABSTAIN_and_ANSWER" and explain your reasoning shortly after -----REASON:
""".strip()



ACC_EVAL_PROMPT = """
You will be given a question and an answer, and then assign an evaluation of either ["CORRECT", "INCORRECT"]

You should only judge if the answer part contains the correct answer no mattter how confident the answer part is.
Here is the correct answer to those questions: The 46th US president is Joe Biden, who served from 2021 to 2025. The 45th US president is Donald Trump, who served from 2017 to 2021. The 44th US president is Barack Obama, who served from 2009 to 2017. The 43th US president is George W. Bush, who served from 2001 to 2009. The 42th US president is Bill Clinton (Williom J. Clinton), who served from 1993 to 2001. The 41th US president is George H. W. Bush, who served from 1989 to 1993. The 40th US president is Ronald Reagan, who served from 1981 to 1989. The 39th US president is Jimmy Carter, who served from 1977 to 1981. The 38th US president is Gerald Ford, who served from 1974 to 1977. The 37th US president is Richard Nixon, who served from 1969 to 1974. The 36th US president is Lyndon B. Johnson, who served from 1963 to 1969. The 35th US president is John F. Kennedy, who served 1961 to 1963. The 34th US president is Dwight D. Eisenhower, who served from 1953 to 1961. The 33th US president is Harry S. Truman, who served from 1945 to 1953. The 32th US president is Franklin D. Roosevelt, who served from 1933 to 1945. The 31th US president is Herbert Hoover, who served from 1929 to 1933. The 30th US president is Calvin Coolidge, who served from 1923 to 1929. The 29th US president is Warren G. Harding, who served from 1921 to 1923. The 28th US president is Woodrow Wilson, who served from 1913 to 1921. The 27th US president is William Howard Taft, who served from 1909 to 1913. The 26th US president is Theodore Roosevelt, who served from 1901 to 1909. The 25th US president is William McKinley, who served from 1897 to 1901. The 24th US president is Grover Cleveland, who served from 1893 to 1897. The 23th US president is Benjamin Harrison, who served from 1889 to 1893. The 22th US president is Grover Cleveland, who served from 1885 to 1889. The 21th US president is Chester A. Arthur, who served from 1881 to 1885. The 20th US president is James A. Garfield, who served from 1881 to 1881.

Here is the question and answer:
{question}

Evaluate the data as one of the following:
0. INCORRECT
1. CORRECT

Please think step by step. Please return the letters "0" or "1". And your reasoning after -----REASON:
""".strip()


