# Model Collapse Is Not a Bug but a Feature in Machine Unlearning for LLMs

## Reproducibility instructions

First finetune models on the ground truth. Then execute **PMC-unlearning**.

**1. Finetuning on full dataset**
```
cd finetuning
python3 main.py -m -cd=configs -cn=phi
python3 main.py -m -cd=configs -cn=llama3
```
This will finetune vanilla models on the full dataset and store resulting models in `models/finetuned/`.

**2.1 PMC-unlearning**

```
cd unlearning
python3 main.py -m -cd=configs -cn=PMC-unlearn-phi
python3 main.py -m -cd=configs -cn=PMC-unlearn-llama3
```

This will apply PMC-unlearning to finetuned models and store resulting models in `models/unlearned/`.

## Installation
Instructions for dependencies and configurations before running code:

```
python -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```
Additionally set `HUGGINGFACE_LOGIN_TOKEN` in each `environment.env`.

This code was tested with Python 3.11.9, pip 24.0, PyTorch 2.3.1+cu118, and CUDA 11.8 on a NVIDIA H100 GPU.