#!/usr/bin/env bash
set -euo pipefail

LOG_DIR="/root/L_MCPPO_ICLR/results/train_logs"
mkdir -p "$LOG_DIR"

python /root/L_MCPPO_ICLR/train.py --algo ppo                       > "$LOG_DIR/ppo.log"              2>&1 &

python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 0 --device "cuda:5"         > "$LOG_DIR/ppo_lag_0.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 0 --device "cuda:5"   > "$LOG_DIR/ppo_lag_multi_0.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 1 --device "cuda:4"         > "$LOG_DIR/ppo_lag_1.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 1 --device "cuda:4"   > "$LOG_DIR/ppo_lag_multi_1.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 2 --device "cuda:3"         > "$LOG_DIR/ppo_lag_2.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 2 --device "cuda:3"   > "$LOG_DIR/ppo_lag_multi_2.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 3 --device "cuda:6"         > "$LOG_DIR/ppo_lag_3.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 3 --device "cuda:6"   > "$LOG_DIR/ppo_lag_multi_3.log"    2>&1 &

python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 4 --device "cuda:1"        > "$LOG_DIR/ppo_lag_4.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 4 --device "cuda:1"  > "$LOG_DIR/ppo_lag_multi_4.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 5 --device "cuda:2"        > "$LOG_DIR/ppo_lag_5.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 5 --device "cuda:2"  > "$LOG_DIR/ppo_lag_multi_5.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 6 --device "cuda:3"        > "$LOG_DIR/ppo_lag_6.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 6 --device "cuda:3"  > "$LOG_DIR/ppo_lag_multi_6.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 7 --device "cuda:4"        > "$LOG_DIR/ppo_lag_7.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 7 --device "cuda:4"  > "$LOG_DIR/ppo_lag_multi_7.log"    2>&1 &

python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 8 --device "cuda:5"        > "$LOG_DIR/ppo_lag_8.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 8 --device "cuda:5"  > "$LOG_DIR/ppo_lag_multi_8.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 9 --device "cuda:6"        > "$LOG_DIR/ppo_lag_9.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 9 --device "cuda:6"  > "$LOG_DIR/ppo_lag_multi_9.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 10 --device "cuda:7"        > "$LOG_DIR/ppo_lag_10.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 10 --device "cuda:7"  > "$LOG_DIR/ppo_lag_multi_10.log"    2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 11 --device "cuda:7"        > "$LOG_DIR/ppo_lag_11.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 11 --device "cuda:7"  > "$LOG_DIR/ppo_lag_multi_11.log"    2>&1 &

python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 12 --device "cuda:1"        > "$LOG_DIR/ppo_lag_12.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 12 --device "cuda:1"  > "$LOG_DIR/ppo_lag_multi_12.log"    2>&1 &

python /root/L_MCPPO_ICLR/train.py --algo ppo_lag --para_set 13 --device "cuda:2"        > "$LOG_DIR/ppo_lag_13.log"          2>&1 &
python /root/L_MCPPO_ICLR/train.py --algo ppo_lag_multi --para_set 13 --device "cuda:2"  > "$LOG_DIR/ppo_lag_multi_13.log"    2>&1 &


# 等待所有后台任务结束
wait
echo "全部训练完成 ✅（日志在 $LOG_DIR）"
