class ConfigDict:
    def __init__(self, **kwargs):
        for key, value in kwargs.items():
            setattr(self, key, value)

cd_config = ConfigDict(
    exp_name="",
    run_name="",
    logging_dir="",
    SEED = 12,
    pre_processed_data_path="",
    sequential_data_dir="",
    metadata_path="",
    graph_data_dir="",
    model_checkpoints_dir='',
    model_develop_dir='',
    latest_model=None,
    train_ratio=0.8, 
    val_ratio=0.1,
    test_ratio=0.1,
    batch_size=256,
    test_batch_size=256,
    epochs=100,
    wd=1e-4,
    dropout=0.1,
    lr=1e-2,
    n_layers=3,
    hidden_channels=8,
    normalize_rho=False,
    out_channels=1,
    is_graph_task=True,
    max_num_GNANs=17,
    n_biom_group_layers=3,
    # Ablation controls (mirrors P12 flags)
    disable_deepset=False,
    disable_distance_embedding=False,
    use_simple_aggregation=False,
    feature_processor_type="gnan",  # 'gnan' | 'simple_linear' | 'identity'
    gnan_mode="per_group",  # 'single' | 'per_group' | 'per_biomarker'
    label_encoder={
        "patient": 0,
        "control": 1
    },
    num_biom=17,
    num_biom_embed=3,
    num_units=9,
    num_units_embed=3,
    num_lab_ids=55,
    num_lab_ids_embed = 5,
    feature_groups=[4, 5, 1, 3], # Value feature group (value, unit_embed), lab feature group (lab_id_embed), demographic group (sex),   biom feature group (biom_embed) NO AGE, NO REF VALUES
    scheduler_T0=50,
    scheduler_decay=0.3,
    end_lr=5e-4,
    biomarker_groups = [
        ["npu02593", "npu02902", "npu02636", "npu02840", "npu01933", "npu01349"],  # White blood cell subtypes
        ["npu19748", "npu19717"],  # Inflammation markers (CRP, F-cal)
        ["npu03568"],  # Platelets
        ["npu02319"],  # Hemoglobin
        ["npu02508"],  # Iron
        ["npu02070", "npu01700", "npu10267"],  # Vitamins and folate
        ["npu19651", "npu01370", "npu19673"],  # Liver function markers
    ]
)