from sqlalchemy import create_engine
import pandas as pd


def query_data(
    connection_string:str,
    save_path:str,
    db_query=None,
):
    print("Querying Data From DB...")
    engine = create_engine(connection_string)

    if not db_query:
        raise Exception

    df = pd.read_sql_query(db_query, con=engine)

    print()
    print("Loaded data, now applying pre-processing ... ")
    
    df = df.apply(lambda x: x.astype(str).str.lower() if x.dtype == "object" else x)
    
    df['samplingdate'] = pd.to_datetime(df['samplingdate'], errors='coerce')
    df['diag_date'] = pd.to_datetime(df['prediag_token_date'], errors='coerce')
    df['value'] = pd.to_numeric(df['value'], errors='coerce')
    df['referenceinterval_lowerlimit'] = pd.to_numeric(df['referenceinterval_lowerlimit'], errors='coerce')
    df['referenceinterval_upperlimit'] = pd.to_numeric(df['referenceinterval_upperlimit'], errors='coerce')

    print()
    print("Pre-processing done, saving data... ")

    df.to_csv(f"{save_path}/raw_data.csv", index=False)

    print("Data Succesfully Fetched ")
    return df