cd_vs_control_17_bioms = """
WITH CD_patients AS (
    SELECT 
        DISTINCT(ibd_basefiles_v1_1.ibd_patients_two_registrations.lbnr::text) AS p_id,
        d_first_ibd_contact AS prediag_token_date,
        ibd_basefiles_v1_1.ibd_patients_two_registrations.d_foddato AS date_of_birth,
        FALSE AS is_healthy,
        t_person.c_kon AS sex,
        ibd_reg1 AS disease_class,
        'patient' AS dataset
    FROM ibd_basefiles_v1_1.ibd_patients_two_registrations
    LEFT JOIN registers_v1.t_person AS t_person
    ON ibd_basefiles_v1_1.ibd_patients_two_registrations.lbnr = t_person.lbnr
    WHERE ibd_reg1 = 'CD'
    LIMIT (50000)
),

UC_patients AS (
    SELECT 
        DISTINCT(ibd_basefiles_v1_1.ibd_patients_two_registrations.lbnr::text) AS p_id,
        d_first_ibd_contact AS prediag_token_date,
        ibd_basefiles_v1_1.ibd_patients_two_registrations.d_foddato AS date_of_birth,
        FALSE AS is_healthy,
        t_person.c_kon AS sex,
        ibd_reg1 AS disease_class,
        'patient' AS dataset
    FROM ibd_basefiles_v1_1.ibd_patients_two_registrations
    LEFT JOIN registers_v1.t_person AS t_person
    ON ibd_basefiles_v1_1.ibd_patients_two_registrations.lbnr = t_person.lbnr
    WHERE ibd_reg1 = 'UC'
),

CONTROLS AS (
    SELECT DISTINCT
        lab_forsker.lbnr::text AS p_id,
        NULL::date AS prediag_token_date,
        t_person.d_foddato::DATE AS date_of_birth,
        TRUE AS is_healthy,
        t_person.c_kon AS sex,
        NULL AS disease_class,
        'control' AS dataset
    FROM registers_v1.lab_forsker TABLESAMPLE SYSTEM(1)
    LEFT JOIN registers_v1.t_person AS t_person
        ON registers_v1.lab_forsker.lbnr = t_person.lbnr
    WHERE
    registers_v1.lab_forsker.lbnr::text NOT IN (
        SELECT p_id FROM CD_patients
    )
    AND 
    registers_v1.lab_forsker.lbnr::text NOT IN (
        SELECT p_id FROM UC_patients
    )
    LIMIT (50000)
),

samples AS (
    SELECT * FROM CD_patients
    UNION
    SELECT * FROM CONTROLS
)

SELECT
    samples.p_id AS lbnr,
    samples.sex,
    samples.dataset,
    samples.prediag_token_date,
    samples.date_of_birth,
    samples.disease_class,
    samples.sex,
    biomarkers.samplingdate,
    biomarkers.samplingtime,
    biomarkers.analysiscode,
    biomarkers.laboratorium_idcode,
    biomarkers.value,
    biomarkers.unit,
    biomarkers.resulttype,
    biomarkers.referenceinterval_lowerlimit,
    biomarkers.referenceinterval_upperlimit,
    biomarkers.rekvirent_idtype
FROM samples
LEFT JOIN registers_v1.lab_forsker AS biomarkers
    ON samples.p_id = biomarkers.lbnr::text
WHERE biomarkers.analysiscode IN (
    'NPU19748', 'NPU19717', 'NPU02593', 'NPU02902', 
    'NPU02636', 'NPU02840', 'NPU01933', 'NPU01349', 
    'NPU03568', 'NPU02319', 'NPU02508', 'NPU02070', 
    'NPU01700', 'NPU10267', 'NPU19651', 'NPU19673', 
    'NPU01370'
)
"""
