import ast
import pandas as pd
import math

def convert_to_tuple(value):
    if isinstance(value, str):
        safe_value = value.replace("nan", "None")
        parsed = ast.literal_eval(safe_value)

        if isinstance(parsed, tuple):
            float_values = [
                    math.nan if x is None else float(x) if i in {0, 3, 4} else str(x)
                    for i, x in enumerate(parsed)
                ]

            return tuple(float_values)

        return value
