#!/bin/bash
#SBATCH --job-name=GMAN_s_disable_deepset
#SBATCH --output=ablation_logs/disable_deepset%j.out
#SBATCH --time=48:00:00
#SBATCH --mem=200G
#SBATCH --gres=gpu:l40s:1

export WANDB_API_KEY=1cdd63c60410fffb99b4990ad947e7cfbb73a625

singularity exec \
  --bind ~/GMAN_venv:/GMAN_venv \
  ~/pytorch_25.06-py3.sif \
  /bin/bash -c "source /GMAN_venv/bin/activate && python run_physionet.py \
  --config_path configs/P_12/biology_informed.yaml\
  --n_layers 8\
  --hidden_channels 256\
  --lr 0.0005\
  --seed 42\
  --dropout 0.3\
  --batch_size 16\
  --val_batch_size 16\
  --test_batch_size 16\
  --deepset_n_layers 2\
  --run_name disable_deepset
  --disable_deepset
  "