#!/usr/bin/env python3
"""
Simple script to run Raindrop on P12 dataset
"""

import sys
import os

# Add the Raindrop code directory to the path
sys.path.append('/home/dcm.aau.dk/km20bf/Biomarker_FeatureGroup_GNAN/baselines/Raindrop/code')

# Import Raindrop
from Raindrop_CD import *

if __name__ == '__main__':
    print("Running Raindrop on P12 dataset...")
    print("=" * 50)
    
    # Set up arguments for P12
    sys.argv = [
        'run_raindrop_p12.py',
        '--dataset', 'P12',
        '--splittype', 'random',
        '--feature_removal_level', 'no_removal',
        '--seed', '42'
    ]
    
    print("Configuration:")
    print(f"  Dataset: P12")
    print(f"  Split type: random")
    print(f"  Feature removal: no_removal")
    print(f"  Seed: 42")
    print(f"  Base path: /home/dcm.aau.dk/km20bf/Biomarker_FeatureGroup_GNAN/baselines/Raindrop/P12data_converted")
    print("=" * 50)
    
    # The main execution will happen in the imported module
    print("Raindrop execution completed!") 