#!/bin/bash
#SBATCH --job-name=GMAN_feature_processor_type_simple_linear
#SBATCH --output=ablation_logs/feature_processor_type_simple_linear%j.out
#SBATCH --time=11:00:00
#SBATCH --mem=100G
#SBATCH --gres=gpu:2
#SBATCH --partition=prioritized

# Set environment variables for distributed training with gloo backend
export NCCL_DEBUG=INFO
export NCCL_IB_DISABLE=1
export NCCL_P2P_DISABLE=1
export NCCL_SOCKET_IFNAME=lo

 singularity exec \
  --bind ~/GMAN_venv:/GMAN_venv \
  ~/pytorch_25.06-py3.sif \
  /bin/bash -c "source /GMAN_venv/bin/activate && python run_physionet_ddp_gloo.py \
  --config_path configs/P_12/biology_informed.yaml\
  --n_layers 3\
  --hidden_channels 8\
  --lr 0.001\
  --batch_size 32\
  --val_batch_size 8\
  --test_batch_size 8\
  --gnan_mode per_group\
  --seed 49\
  --run_name feature_processor_type_simple_linear\
  --warmup_epochs 0\
  --dropout 0.3\
  --predictive_label LoS\
  --los_threshold_days 3\
  --use-cached-dataset \
  --cached_dataset_dir /home/dcm.aau.dk/km20bf/Biomarker_FeatureGroup_GNAN/tmp_48h \
  --split_pkl_path /home/dcm.aau.dk/km20bf/Biomarker_FeatureGroup_GNAN/P12_data_splits/split_1.pkl \
  --feature_processor_type simple_linear \
  " 
