# Revisiting Supervision for Continual Representation Learning

## Installation
Use the following commands to create an environment and install the required packages (needs `conda`):
```
conda create --name cassle python=3.8
conda activate cassle
pip3 install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
pip install pytorch-lightning lightning-bolts wandb scikit-learn einops
pip install --extra-index-url https://developer.download.nvidia.com/compute/redist --upgrade nvidia-dali-cuda110
```
Remember to check your cuda version and modify the install commands accorgingly.


## Datasets
Most of the datasets (CIFAR10, CIFAR100, SVHN) are automatically downloaded by `torchvision.datasets` module. ImageNet100 is a subset of [ImageNet dataset](https://www.image-net.org/index.php) containing 100 classes defined [here](https://github.com/HobbitLong/CMC/blob/master/imagenet100.txt).

## Reproducibility

### Main results
To reproduce main results from Tab. 1 and Fig. 2 run:
```bash
bash run_main_results.bash
```

### Two-task experiments
To reproduce two-task results from Fig. 3 - Fig. 5 and Tab. 2 - Tab. 3 run:
```bash
bash run_2_task_exps.bash
```

### Supervised ablation
To reproduce results from supervised ablation study from Tab. 4 run:
```bash
bash run_supervised_ablation.bash
```

### Stability of representations
To reproduce results of Fig. 6:
* insert checkpoints paths into `nmc-classifier.py` script
* run it with `python nmc-classifier.py`


## Logging
Logging is performed with [WandB](https://wandb.ai/site). Please create an account and specify your `--entity YOUR_ENTITY` and `--project YOUR_PROJECT` in the bash scripts. For debugging, or if you do not want all the perks of WandB, you can disable logging by passing `--offline` in your bash scripts. After training you can always sync an offline run with the following command: `wandb sync your/wandb/run/folder`.

## Credits

Repo is based on https://github.com/DonkeyShot21/cassle
