data_root=
model_root=
peft_root=${data_root}/output
cost_model_root=
MODELS=(Llama-2-7b-hf gemma-7b Mistral-7B-v0.1)
PEFT_NAME=(sharegpt_ia3_ff_1 sharegpt_ia3_ff_1_hh_harmless_dpo_ia3_ff)
# TOPK=3000
NUM_SAMPLE=5000
BATCH_SIZE=50
# dataset_dir=(data/eval/jailbreak_llms/jailbreak_llms.jsonl data/eval/hh_rlhf_harmless/hh_harmless_data_train.jsonl data/raw_train/BeaverTails/test.jsonl data/eval/harmbench/harmbench.jsonl data/eval/red_team_attempts/red_team_attempts.jsonl)
# dataset_name=(jailbreak_llms hh_harmless beavertails harmbench red_team_attempts)
dataset_dir=(data/eval/hh_rlhf_harmless/hh_harmless_data_train.jsonl)
dataset_name=(hh_harmless)
TOPK=(1500 1200 900 700 500 300 150 50 30 20 10)
SEED=(1 42 66 88 3419)

for MODEL in ${MODELS[@]}
do
    PEFT_PATH=()
    for ((i=0; i<${#PEFT_NAME[*]}; ++i)) 
    do
        PEFT_PATH[i]=${peft_root}/${MODEL}_${PEFT_NAME[i]}
    done

for ((i=0; i<${#dataset_dir[*]}; ++i)) 
do
    python -m hooked_models.neuron_activation \
        --dataset ${data_root}/${dataset_dir[i]} \
        --output_dir ${data_root}/output/activations/harmless_prediction \
        --output_filename ${dataset_name[i]}_${NUM_SAMPLE}_${MODEL}_${PEFT_NAME[0]} \
        --model_name_or_path ${model_root}/${MODEL} \
        --tokenizer_name_or_path ${model_root}/${MODEL} \
        --cost_model_name_or_path ${cost_model_root}/beaver-7b-v1.0-cost \
        --index_path ${data_root}/hooked_llama/neuron_activation/${MODEL}_${PEFT_NAME[-1]}_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
        --peft_path ${PEFT_PATH[0]} \
        --eval_batch_size ${BATCH_SIZE} \
        --num_samples ${NUM_SAMPLE} \
        --topk 1500

    python -m hooked_models.neuron_activation \
        --dataset ${data_root}/${dataset_dir[i]} \
        --output_dir ${data_root}/output/activations/harmless_prediction \
        --output_filename ${dataset_name[i]}_${NUM_SAMPLE}_${MODEL}_${PEFT_NAME[-1]} \
        --model_name_or_path ${model_root}/${MODEL} \
        --tokenizer_name_or_path ${model_root}/${MODEL} \
        --cost_model_name_or_path ${cost_model_root}/beaver-7b-v1.0-cost \
        --index_path ${data_root}/hooked_llama/neuron_activation/${MODEL}_${PEFT_NAME[-1]}_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
        --peft_path ${PEFT_PATH[@]} \
        --eval_batch_size ${BATCH_SIZE} \
        --num_samples ${NUM_SAMPLE} \
        --topk 1500

    # python -m hooked_models.neuron_activation \
    #     --dataset ${data_root}/${dataset_dir[i]} \
    #     --output_dir ${data_root}/output/activations/harmless_prediction \
    #     --output_filename ${dataset_name[i]}_${NUM_SAMPLE}_${MODEL}_${PEFT} \
    #     --model_name_or_path ${model_root}/${MODEL} \
    #     --tokenizer_name_or_path ${model_root}/${MODEL} \
    #     --cost_model_name_or_path ${cost_model_root}/beaver-7b-v1.0-cost \
    #     --index_path ${data_root}/hooked_llama/neuron_activation/Llama-2-7b-hf_sharegpt_ia3_ff_1_hh_harmless_dpo_ia3_ff_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
    #     --peft_path ${data_root}/output/${MODEL}_${PEFT} \
    #     --eval_batch_size ${BATCH_SIZE} \
    #     --num_samples ${NUM_SAMPLE} \
    #     --topk ${TOPK[@]} \
    #     --seed ${SEED[@]} \
    #     --use_random_neurons 

    # python -m hooked_models.neuron_activation \
    #     --dataset ${data_root}/${dataset_dir[i]} \
    #     --output_dir ${data_root}/output/activations/harmless_prediction \
    #     --output_filename ${dataset_name[i]}_${NUM_SAMPLE}_${MODEL}_${PEFT}_last \
    #     --model_name_or_path ${model_root}/${MODEL} \
    #     --tokenizer_name_or_path ${model_root}/${MODEL} \
    #     --cost_model_name_or_path ${cost_model_root}/beaver-7b-v1.0-cost \
    #     --index_path ${data_root}/hooked_llama/neuron_activation/Llama-2-7b-hf_sharegpt_ia3_ff_1_hh_harmless_dpo_ia3_ff_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
    #     --peft_path ${data_root}/output/${MODEL}_${PEFT} \
    #     --eval_batch_size ${BATCH_SIZE} \
    #     --num_samples ${NUM_SAMPLE} \
    #     --topk ${TOPK[@]} \
    #     --seed ${SEED[@]} \
    #     --use_random_neurons \
    #     --last_layer_neurons
        
    # python -m hooked_models.neuron_activation \
    #     --dataset ${data_root}/${dataset_dir[i]} \
    #     --output_dir ${data_root}/output/activations/harmless_prediction \
    #     --output_filename ${dataset_name[i]}_${NUM_SAMPLE}_${MODEL}_${PEFT}_everywhere \
    #     --model_name_or_path ${model_root}/${MODEL} \
    #     --tokenizer_name_or_path ${model_root}/${MODEL} \
    #     --cost_model_name_or_path ${cost_model_root}/beaver-7b-v1.0-cost \
    #     --index_path ${data_root}/hooked_llama/neuron_activation/Llama-2-7b-hf_sharegpt_ia3_ff_1_hh_harmless_dpo_ia3_ff_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
    #     --peft_path ${data_root}/output/${MODEL}_${PEFT} \
    #     --eval_batch_size ${BATCH_SIZE} \
    #     --num_samples ${NUM_SAMPLE} \
    #     --topk ${TOPK[@]} \
    #     --seed ${SEED[@]} \
    #     --use_random_neurons \
    #     --random_neurons_everywhere

    # python -m hooked_models.lora_activation \
    #     --dataset ${data_root}/data/raw_train/BeaverTails/train.jsonl \
    #     --output_dir ${data_root}/output/activations/ \
    #     --output_filename beavertails_${NUM_SAMPLE}_${MODEL}_${PEFT}_top${TOPK} \
    #     --model_name_or_path ${model_root}/${MODEL} \
    #     --tokenizer_name_or_path ${model_root}/${MODEL} \
    #     --cost_model_name_or_path ${model_root}/beaver-7b-v1.0-cost \
    #     --index_path ${data_root}/hooked_llama/neuron_activation/Llama-2-7b-hf_sharegpt_ia3_ff_1_hh_harmless_dpo_ia3_ff_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
    #     --peft_path ${data_root}/output/${MODEL}_${PEFT} \
    #     --eval_batch_size ${BATCH_SIZE} \
    #     --num_samples ${NUM_SAMPLE} \
    #     --topk ${TOPK} 

    # python -m hooked_models.lora_activation \
    #     --dataset ${data_root}/data/raw_train/BeaverTails/train.jsonl \
    #     --output_dir ${data_root}/output/activations/ \
    #     --output_filename beavertails_${NUM_SAMPLE}_${MODEL}_${PEFT}_top${TOPK}_random \
    #     --model_name_or_path ${model_root}/${MODEL} \
    #     --tokenizer_name_or_path ${model_root}/${MODEL} \
    #     --cost_model_name_or_path ${model_root}/beaver-7b-v1.0-cost \
    #     --index_path ${data_root}/hooked_llama/neuron_activation/Llama-2-7b-hf_sharegpt_ia3_ff_1_hh_harmless_dpo_ia3_ff_sft_vs_dpo_on_hh_harmless_sft_completion.pt \
    #     --peft_path ${data_root}/output/${MODEL}_${PEFT} \
    #     --eval_batch_size ${BATCH_SIZE} \
    #     --num_samples ${NUM_SAMPLE} \
    #     --topk ${TOPK} \
    #     --use_random_neurons
done
done