

data_root=
model_root=
MODEL=Llama-2-7b-hf
NUM_GPUS=6
BATCH_SIZE_PER_GPU=5
TOTAL_BATCH_SIZE=120
GRADIENT_ACC_STEPS=$(($TOTAL_BATCH_SIZE/$NUM_GPUS/$BATCH_SIZE_PER_GPU))
echo "Training llama model ${MODEL_SIZE} using $NUM_GPUS GPUs, $BATCH_SIZE_PER_GPU batch size per GPU, $GRADIENT_ACC_STEPS gradient accumulation steps"

deepspeed --include localhost:0,1,2,3,4,5 --module training.reward_modelling \
    --deepspeed configs/ds_configs/stage2_no_offloading.conf \
    --cache_dir  \
    --model_name_or_path ${model_root}/${MODEL} \
    --tokenizer_name ${model_root}/${MODEL} \
    --use_flash_attn True \
    --use_fast_tokenizer False \
    --remove_unused_columns False \
    --train_file ${data_root}/data/raw_train/hh_rlhf_harmless/train.jsonl \
    --test_file ${data_root}/data/raw_train/hh_rlhf_harmless/test.jsonl \
    --max_length 4096 \
    --preprocessing_num_workers 64 \
    --do_train \
    --per_device_train_batch_size $BATCH_SIZE_PER_GPU \
    --gradient_accumulation_steps $GRADIENT_ACC_STEPS \
    --learning_rate 1e-4 \
    --lr_scheduler_type linear \
    --warmup_ratio 0.03 \
    --weight_decay 0. \
    --evaluation_strategy "epoch" \
    --logging_steps 10 \
    --save_strategy "epoch" \
    --num_train_epochs 3 \
    --output_dir ${data_root}/output/${MODEL}_hh_harmless_rm \
    --report_to "wandb" \
    --bf16 \
    --gradient_checkpointing 
