Storm - A Modern Probabilistic Model Checker
============================================

[![Build Status](https://github.com/moves-rwth/storm/workflows/Build%20Test/badge.svg)](https://github.com/moves-rwth/storm/actions)
[![GitHub release](https://img.shields.io/github/release/moves-rwth/storm.svg)](https://github.com/moves-rwth/storm/releases/)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1181896.svg)](https://doi.org/10.5281/zenodo.1181896)


Usage
-----------------------------
The Storm website [www.stormchecker.org](https://www.stormchecker.org/) provides documentation and background information.
- For installation and usage instructions, check out the documentation found in [Getting Started](http://www.stormchecker.org/getting-started.html).
- Video tutorials and interactive code examples are available in [Tutorials](https://www.stormchecker.org/tutorials.html).
- The [Storm starter project](https://github.com/moves-rwth/storm-project-starter-cpp/) provides a starting point for incorporating Storm into C++ projects.
- Storm provides a Python interface called [stormpy](https://moves-rwth.github.io/stormpy/) for easy prototyping and interaction with Storm.
- In case of any issues installing or using Storm, [let us know](https://www.stormchecker.org/documentation/obtain-storm/troubleshooting.html).


Examples
-----------------------------
Various benchmarks together with example invocations of Storm can be found at the [Quantitative Verification Benchmark Set (QVBS)](http://qcomp.org/benchmarks).
Additional input files for Storm can be obtained from the [storm-examples](https://github.com/moves-rwth/storm-examples) repository.


Developers
-----------------------------
We welcome contributions to Storm.
Our [information for developers](doc/developers.md) contains general information to get started with the development on Storm.
Feel free to contact us in case you need any pointers or help.


Authors
-----------------------------
Storm has been developed at RWTH Aachen University.

###### Principal developers
* Christian Hensel
* Sebastian Junges
* Joost-Pieter Katoen
* Tim Quatmann
* Matthias Volk

###### Developers (lexicographical order)
* Jana Berger
* Alexander Bork
* David Korzeniewski
* Jip Spel

###### Contributors (lexicographical order)
* Daniel Basgöze
* Dimitri Bohlender
* Harold Bruintjes
* Michael Deutschen
* Linus Heck
* Thomas Heinemann
* Thomas Henn
* Tom Janson
* Jan Karuc
* Joachim Klein
* Gereon Kremer
* Sascha Vincent Kurowski
* Hannah Mertens
* Stefanie Mohr
* Stefan Pranger
* Svenja Stein
* Manuel Sascha Weiand
* Lukas Westhofen

For an exhaustive list of contributors and more details, see the [Github page](https://github.com/moves-rwth/storm/graphs/contributors).


Citing Storm
-----------------------------
If you want to cite Storm, please use the most recent paper in [this category](https://www.stormchecker.org/publications.html).
