#include "RemoveBoundVisitor.h"

#include <boost/any.hpp>

#include "storm/logic/Formulas.h"

namespace storm::logic {

std::shared_ptr<Formula> RemoveBoundVisitor::dropBounds(const storm::logic::Formula& f) const {
    boost::any result = f.accept(*this, boost::any());
    return boost::any_cast<std::shared_ptr<Formula>>(result);
}

boost::any RemoveBoundVisitor::visit(BoundedUntilFormula const& f, boost::any const&) const {
    STORM_LOG_ASSERT(!f.hasMultiDimensionalSubformulas(), "Cannot turn a bounded Until formula into an unbounded one if it has multidimensional subformulas!");
    auto left = boost::any_cast<std::shared_ptr<Formula>>(f.getLeftSubformula().accept(*this));
    return std::static_pointer_cast<Formula>(std::make_shared<UntilFormula>(left, std::make_shared<AtomicLabelFormula>("goal")));
}

}  // namespace storm::logic
