#!/usr/bin/env bash

# sh run_fedavg_distributed_pytorch.sh 10 10 1 4 resnet18 hetero 2 1 64 0.001 cifar10 "./../../../data/cifar10" adam 0 FedAvg 1000

# sh run_fedavg_distributed_pytorch.sh 10 10 1 4 resnet18 hetero 2 1 64 0.001 cifar10 "./../../../data/cifar10" adam 0 Ditto 2000

# sh run_fedavg_distributed_pytorch.sh 10 10 1 4 resnet18 hetero 2 1 64 0.001 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 3000

#sh run_fedavg_distributed_pytorch.sh 10 4 1 4 resnet18 hetero 20 1 32 0.001 cifar10 "./../../../data/cifar10" adam 0 Ditto 2000 0


#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.001 cifar10 "./../../../data/cifar10" adam 0 Ditto 3000 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.01 cifar10 "./../../../data/cifar10" adam 0 Ditto 3001 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.1 cifar10 "./../../../data/cifar10" adam 0 Ditto 3002 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.003 cifar10 "./../../../data/cifar10" adam 0 Ditto 3003 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.03 cifar10 "./../../../data/cifar10" adam 0 Ditto 3004 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.3 cifar10 "./../../../data/cifar10" adam 0 Ditto 3005 0

#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.001 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 96 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.003 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 93 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.01 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 91 4
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.03 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 92 4

#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.1 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 7004 4
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 hetero 500 1 32 0.3 cifar10 "./../../../data/cifar10" adam 0 perFedAvg 7005 4



#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.001 cifar10 "./../../../data/cifar10" adam 0 Ditto 300 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.01 cifar10 "./../../../data/cifar10" adam 0 Ditto 310 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.1 cifar10 "./../../../data/cifar10" adam 0 Ditto 320 4
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.003 cifar10 "./../../../data/cifar10" adam 0 Ditto 330 4
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.03 cifar10 "./../../../data/cifar10" adam 0 Ditto 340 0
#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.3 cifar10 "./../../../data/cifar10" adam 0 Ditto 350 0

#sh run_fedavg_distributed_pytorch.sh 20 4 1 4 resnet18 lda 500 1 32 0.3 gld23k "./../../../data/gld" adam 0 Ditto 350 0
#GLD23k (lambda 1) - Killed
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.3 gld23k "./../../../data/gld" adam 0 Ditto 1 4
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.1 gld23k "./../../../data/gld" adam 0 Ditto 2 4


#Lambda 4 (Killed)
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.01 gld23k "./../../../data/gld" adam 0 Ditto 3 0
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.03 gld23k "./../../../data/gld" adam 0 Ditto 4 0

#Running (Lambda 1)
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.003 gld23k "./../../../data/gld" adam 0 Ditto 5 4
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.001 gld23k "./../../../data/gld" adam 0 Ditto 6 4

#MAML (lambda 4 bottom)
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.03 gld23k "./../../../data/gld" adam 0 perFedAvg 15 4
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.01 gld23k "./../../../data/gld" adam 0 perFedAvg 16 4

#MAML (Lambda 3)
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.003 gld23k "./../../../data/gld" adam 0 perFedAvg 11 4
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.001 gld23k "./../../../data/gld" adam 0 perFedAvg 12 0

#MAML
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.1 gld23k "./../../../data/gld" adam 0 perFedAvg 17 4
#sh run_fedavg_distributed_pytorch.sh 20 8 1 4 resnet18 lda 3000 1 32 0.3 gld23k "./../../../data/gld" adam 0 perFedAvg 18 4


CLIENT_NUM=$1
WORKER_NUM=$2
SERVER_NUM=$3
GPU_NUM_PER_SERVER=$4
MODEL=$5
DISTRIBUTION=$6
ROUND=$7
EPOCH=$8
BATCH_SIZE=$9
LR=${10}
DATASET=${11}
DATA_DIR=${12}
CLIENT_OPTIMIZER=${13}
CI=${14}
PER_OPT=${15}
RUN_ID=${16}
GPU_STARTING_FROM=${17}

PROCESS_NUM=`expr $WORKER_NUM + 1`
echo $PROCESS_NUM

hostname > mpi_host_file

mpirun -np $PROCESS_NUM -hostfile ./mpi_host_file python3 ./main_fedavg.py \
  --gpu_server_num $SERVER_NUM \
  --gpu_num_per_server $GPU_NUM_PER_SERVER \
  --model $MODEL \
  --dataset $DATASET \
  --data_dir $DATA_DIR \
  --partition_method $DISTRIBUTION  \
  --client_num_in_total $CLIENT_NUM \
  --client_num_per_round $WORKER_NUM \
  --comm_round $ROUND \
  --epochs $EPOCH \
  --client_optimizer $CLIENT_OPTIMIZER \
  --batch_size $BATCH_SIZE \
  --lr $LR \
  --ci $CI \
  --starting_gpu_id $GPU_STARTING_FROM \
  --per_optimizer $PER_OPT \
  --run_id $RUN_ID
