#!/usr/bin/env bash
# Search Stages

# Final (lambda 3)
#sh run_GLD23k.sh 1 1 20 1 resnet18 hetero 3000 1 32 0.1 3e-4 999 nas 8 train 1 4 True
#sh run_GLD23k.sh 1 1 20 1 resnet18 hetero 3000 1 32 0.1 3e-4 999 nas 8 fednas_search 1 0 True

SERVER_NUM=$1
GPU_NUM_PER_SERVER=$2
CLIENT_NUM=$3
WORKER_NUM=$4
MODEL=$5
DISTRIBUTION=$6
ROUND=$7
EPOCH=$8
BATCH_SIZE=$9
W_LR=${10}
ALPHA_LR=${11}
RUN_ID=${12}
DESIGN=${13}
Layers=${14}
STAGE=${15}
TRAIN_EPOCH=${16}
GPU_STARTING_FROM=${17}
LOCAL_FINETUNE=${18}

hostname > mpi_host_file

PROCESS_NUM=`expr $WORKER_NUM + 1`

echo $PROCESS_NUM

mpirun -np $PROCESS_NUM -hostfile ./mpi_host_file python3 ./main_fednas.py \
  --gpu_server_num $SERVER_NUM \
  --gpu_num_per_server $GPU_NUM_PER_SERVER \
  --run_id $RUN_ID \
  --model $MODEL \
  --dataset gld23k \
  --design $DESIGN \
  --partition_method $DISTRIBUTION  \
  --client_num_per_round $WORKER_NUM \
  --client_num_in_total $CLIENT_NUM \
  --comm_round $ROUND \
  --epochs $EPOCH \
  --batch_size $BATCH_SIZE \
  --learning_rate $W_LR \
  --lr $W_LR \
  --gamma 0 \
  --beta 0 \
  --epochs_for_train $TRAIN_EPOCH\
  --classes_per_client 5\
  --arch_learning_rate $ALPHA_LR \
  --layers $Layers \
  --local_finetune $LOCAL_FINETUNE\
  --stage $STAGE \
  --starting_gpu_id $GPU_STARTING_FROM \
  --data_dir './../../../data/gld'

#  --data_dir './../../../../../../data/cifar10'
#  --data_dir '/data/gld'
#  --data_dir './../../../data/gld'
#  --data_dir '/data/gld'
#  --data_dir './../../../data/gld'
#  --data_dir './../../../data/gld'
#  --data_dir '/data/gld'
#  --data_dir './../../../data/gld'
#  --data_dir '/data/gld'
#  --data_dir './../../../data/gld'
#  --data_dir '/data/gld'
#  --data_dir './../../../data/gld'
#  --data_dir '/data/gld'
#  --data_dir "/data/gld/" \
#  --client_num_in_total $CLIENT_NUM
#   --data_dir "/data/gld/" \
#  --data_dir './../../../data/gld/'

#  --data_dir "/data/gld/"
#  --data_dir './../../../data/gld/'
#  --data_dir "/data/gld/"
#  --data_dir './../../../data/gld/'
#  --data_dir "/data/gld/"
#  --data_dir './../../../data/gld/'  # if cpu
#  --data_dir "/data/gld/"
#  --data_dir '/home/chaoyanghe/sourcecode/fedml.ai/data/gld/'
#  --data_dir './../../../../../../../data/gld/images' # if server
#  --data_dir './../../../data/gld/images'  # if cpu



#mpirun -np 3 -hostfile ./mpi_host_file python3 ./main_fednas.py \
#--gpu_server_num 1 \
#--gpu_num_per_server 4 \
#--model "transformer" \
#--dataset cifar10 \
#--partition_method homo  \
#--client_number 4 \
#--comm_round 10 \
#--epochs 1 \
#--batch_size 64