import sys
from utils.util import bold, construct_save_dir, save_ft_config
from utils.selection import get_qa_prompt, get_label_response, get_qe_prompt, get_ea_response, get_ft_examples

# Parameters of pipeline to run after finetuning
ft_config = {
    "dataset": '',
    "dataset_params": {
        "split": "test",
        "n": 100,
        "seed": 42
    },
    "llm": '',
    "temperature": 0.0,
    "max_tokens": 512,
    "n_eval": 100,
    "n_samples_per_eval": 1
}

if __name__ == '__main__':
    # Parse dataset/model from command line arguments
    dataset_name, model_name = sys.argv[1], sys.argv[2]
    print(bold(f"Generating finetuning examples for {dataset_name}/{model_name}"))
    ft_config['dataset'] = dataset_name
    ft_config['llm'] = model_name

    save_dir = construct_save_dir(ft_config, save_config=False, prefix='ft_configs')
    responses_dir = f'results/{dataset_name}/{model_name}/' + 'train_n_400_seed_42_temp_{}_maxtokens_512/responses/'

    run_name_args = {
        'baseline_2':   [responses_dir.format(0.0), 100, get_qa_prompt, get_label_response, False],
        'baseline_3':   [responses_dir.format(0.0), 100, get_qe_prompt, get_ea_response, False],
        'approach_1':   [responses_dir.format(0.0), 10,  get_qe_prompt, get_ea_response, False],
        'approach_2':   [responses_dir.format(0.3), 100, get_qe_prompt, get_ea_response, False],
        'approach_3':   [responses_dir.format(0.3), 10,  get_qe_prompt, get_ea_response, False],
        'approach_4':   [responses_dir.format(0.0), 50,  get_qe_prompt, get_ea_response, False],
        'approach_5':   [responses_dir.format(0.3), 50,  get_qe_prompt, get_ea_response, False],
        'baseline_3_c': [responses_dir.format(0.0), 100, get_qe_prompt, get_ea_response, True],
        'approach_1_c': [responses_dir.format(0.0), 10,  get_qe_prompt, get_ea_response, True],
        'approach_2_c': [responses_dir.format(0.3), 100, get_qe_prompt, get_ea_response, True],
        'approach_3_c': [responses_dir.format(0.3), 10,  get_qe_prompt, get_ea_response, True],
        'approach_4_c': [responses_dir.format(0.0), 50,  get_qe_prompt, get_ea_response, True],
        'approach_5_c': [responses_dir.format(0.3), 50,  get_qe_prompt, get_ea_response, True],

    }

    # Collect and save finetuning examples
    for run_name, args in run_name_args.items():
        save_ft_config(ft_config, save_dir, run_name, args[0], get_ft_examples(*args))
        print(f"Saved {run_name} config")
    print()
