#!/bin/bash
# cifar100 ema alpha 0.8 flip weight 2.0
# tiny imagenet ema alpha 0.5 flip weight 2.0
# Default values 
GPU_ID=0
ARCH='Hendrycks2020AugMix_WRN' #['Hendrycks2020AugMix_WRN', 'resnet50','vit-tiny','swin-tiny']
DATASET="cifar100" 
EMA_ALPHA=0.8
FLIP_WEIGHT=2.0
OOD_DATASET="svhn"
DATA_DIR="./data"
CKPT_DIR="./ckpt"
CORRUPTION="all" # "original" for clean data, "all" for all corruptions, or specific corruption types
SEVERITY=5
SEED=7
BATCH_SIZE=100
NUM_BATCHES=0
SPACE="feature"
AUTO_CORRECTION=0
FEATURE_LAYER="multi" 
CONFIDENCE_THRESHOLD=0.25
IQR_FACTOR=1.5
USE_CONFIDENCE=0  
USE_OUTLIER_REMOVAL=1  
TEMPERATURE=5.0
TARGET_METHODS="MSP,Max_logit,Energy,Entropy,ODIN,GradNorm,Mahalanobis_single,Mahalanobis_ensemble,KNN,ViM,RDS"
# Parameter combinations to explore
FEATURE_LAYERS=("single" "multi")


# Parse command line arguments
while [[ $# -gt 0 ]]; do
  key="$1"
  case $key in
    -g|--gpu)
      GPU_ID="$2"
      shift
      shift
      ;;
    -d|--dataset)
      DATASET="$2"
      shift
      shift
      ;;
    -c|--corruption)
      CORRUPTION="$2"
      shift
      shift
      ;;
    -s|--severity)
      SEVERITY="$2"
      shift
      shift
      ;;
    -r|--random_seed)
      SEED="$2"
      shift
      shift
      ;;
    -b|--batch-size)
      BATCH_SIZE="$2"
      shift
      shift
      ;;
    -n|--num-batches)
      NUM_BATCHES="$2"
      shift
      shift
      ;;
    --space)
      SPACE="$2"
      shift
      shift
      ;;
    --ema)
      EMA_ALPHA="$2"
      shift
      shift
      ;;
    --auto-correction)
      AUTO_CORRECTION=1
      shift
      ;;
    --feature-layer)
      FEATURE_LAYER="$2"
      shift
      shift
      ;;
    --confidence-threshold)
      CONFIDENCE_THRESHOLD="$2"
      shift
      shift
      ;;
    --iqr-factor)
      IQR_FACTOR="$2"
      shift
      shift
      ;;
    --use-confidence)
      USE_CONFIDENCE=1
      shift
      ;;
    --use-outlier-removal)
      USE_OUTLIER_REMOVAL=1
      shift
      ;;
    --run-all-combinations)
      RUN_ALL_COMBINATIONS=1
      shift
      ;;
    -h|--help)
      echo "Usage: run_eval.sh [options]"
      echo ""
      echo "Options:"
      echo "  -g, --gpu GPU_ID              GPU ID to use (default: 0)"
      echo "  -a, --arch ARCH               Architecture name: 'Standard', 'Hendrycks2020AugMix_WRN', 'Hendrycks2020AugMix_ResNeXt', 'resnet50','vit','swin'"
      echo "  -d, --dataset DATASET         Dataset name: cifar10, cifar100 (default: cifar10)"
      echo "  -c, --corruption CORRUPTION   Corruption type or 'all' (default: all)"
      echo "  -s, --severity SEVERITY       Corruption severity 1-5 (default: 5)"
      echo "  -r, --seed SEED               Random seed (default: 1)"
      echo "  -t, --target-methods METHODS  Target methods: RDS, Energy, MSP, Entropy, GradNorm, ViM, KNN, Mahalanobis_single, Mahalanobis_ensemble, ODIN (default: all)"
      echo "  -b, --batch-size SIZE         Batch size (default: 100)"
      echo "  -n, --num-batches NUM         Number of batches to evaluate (default: 0 = full dataset)"
      echo "  --space SPACE                 Space for RDS: feature, logit (default: feature)"
      echo "  --ema ALPHA                   EMA coefficient for RDS (default: 0.5)"
      echo "  --auto-correction             Enable auto-correction mechanism (disabled by default)"
      echo "  --feature-layer LAYER         Feature extraction layer (default: block3)"
      echo "  --confidence-threshold THRES  Confidence threshold for updates (default: 0.25)"
      echo "  --iqr-factor FACTOR           IQR factor for outlier detection (default: 1.5)"
      echo "  --use-confidence             Enable confidence-based updates (disabled by default)"
      echo "  --use-outlier-removal        Enable outlier removal for RDS (disabled by default)"
      echo "  --run-all-combinations        Run all parameter combinations"
      echo "  -h, --help                    Show this help message"
      exit 0
      ;;
    *)
      echo "Unknown option: $1"
      echo "Use --help to see available options"
      exit 1
      ;;
  esac
done

# Original behavior - run with default or user-specified parameters
# Set GPU
export CUDA_VISIBLE_DEVICES=$GPU_ID
echo "Using GPU: $GPU_ID"

# Build command
CMD="python run_eval.py"
CMD="$CMD --arch $ARCH"
CMD="$CMD --dataset $DATASET"
CMD="$CMD --ood_dataset $OOD_DATASET"
CMD="$CMD --data_dir $DATA_DIR"
CMD="$CMD --ckpt_dir $CKPT_DIR"
CMD="$CMD --corruption $CORRUPTION"
CMD="$CMD --severity $SEVERITY"
CMD="$CMD --seed $SEED"
CMD="$CMD --batch_size $BATCH_SIZE"
CMD="$CMD --num_batches $NUM_BATCHES"
CMD="$CMD --space $SPACE"
CMD="$CMD --ema_alpha $EMA_ALPHA"
CMD="$CMD --temperature $TEMPERATURE"
CMD="$CMD --flip_weight $FLIP_WEIGHT"
CMD="$CMD --feature_layer $FEATURE_LAYER"
CMD="$CMD --confidence_threshold $CONFIDENCE_THRESHOLD"
CMD="$CMD --iqr_factor $IQR_FACTOR"
CMD="$CMD --target_methods $TARGET_METHODS"
# Optional flags
if [ $AUTO_CORRECTION -eq 1 ]; then
  CMD="$CMD --auto_correction"
fi
if [ $USE_CONFIDENCE -eq 1 ]; then
  CMD="$CMD --use_confidence"
fi
if [ $USE_OUTLIER_REMOVAL -eq 1 ]; then
  CMD="$CMD --use_outlier_removal"
fi

# Print and execute command
echo "Executing: $CMD"
eval $CMD

echo "Evaluation complete!"
