# SGORNN
Code for scalar gated orthogonal RNNs

# Instructions

This code was tested using Python 3.7.11 using tensorflow-gpu 1.15.0 (installed through conda).
The closest version found for ease of use on CPU (without conda) is provided in the `requirements.txt`,
which is 1.15.2. Note that results may vary slightly if GPU/conda is not used.

To install through pip, do `pip install .` or similar from the `SGORNN` directory.
Be sure to run `pip install -r requirements.txt` as well, to get the needed dependencies.
If you installed `tensorflow-gpu==1.15.0` on your own (recommended), you should remove the tensorflow
dependency from the requirements before installing.

To run an experiment, use one of the following three scripts:
1. `scripts/addition.py` for the addition problem
2. `scripts/har2.py` for HAR-2 classification
3. `scripts/ptb.py` for word-level language modelling

The specific commands to replicate the paper results (for the SGORNN model) are:

1. `python addition.py --sequence-length <T>` (`T` is `500`, `1000`, or `5000`)
2. `python har2.py --seed <i>` (`i` is in `[1,2,3,4,5,6,7,8,9,10]` as explained in the paper)
3. `python ptb.py`

To replicate other model results use the `--model-type` option on the scripts.
Use `--help` on a script to see hyperparameter options (e.g. learning rate).
