# Foreground Confusion under Domain Shift: The Hidden Bottleneck in Source‑Free Domain Adaptive Object Detection

[![Framework: PyTorch](https://img.shields.io/badge/Framework-PyTorch-orange.svg)](https://pytorch.org/) 


## Installation Instructions
- We use Python 3.6, PyTorch 1.9.0 (CUDA 10.2 build).
- The codebase is built on [Detectron](https://github.com/facebookresearch/detectron2).

```angular2
conda create -n focus python=3.6

conda activate focus

conda install pytorch==1.9.0 torchvision==0.10.0 torchaudio==0.9.0 cudatoolkit=10.2 -c pytorch

cd Focus-SFOD
pip install -r requirements.txt

## Make sure you have GCC and G++ version <=8.0
python setup.py

```



## Dataset Preparation

* **PASCAL_VOC 07+12**: Please follow the instructions in [py-faster-rcnn](https://github.com/rbgirshick/py-faster-rcnn#beyond-the-demo-installation-for-training-and-testing-models) to prepare VOC datasets.
* **Clipart, WaterColor**: Dataset preparation instruction link [Cross Domain Detection ](https://github.com/naoto0804/cross-domain-detection/tree/master/datasets). Images translated by Cyclegan are available in the website.
* **Sim10k**: Website [Sim10k](https://fcav.engin.umich.edu/sim-dataset/)
* **CitysScape, FoggyCityscape**: Download website [Cityscape](https://www.cityscapes-dataset.com/), see dataset preparation code in [DA-Faster RCNN](https://github.com/tiancity-NJU/da-faster-rcnn-PyTorch)

Download all the dataset into "./dataset" folder.
The codes are written to fit for the format of PASCAL_VOC.
For example, the dataset [Sim10k](https://fcav.engin.umich.edu/sim-dataset/) is stored as follows.

```
$ cd ./dataset/Sim10k/VOC2012/
$ ls
Annotations  ImageSets  JPEGImages
$ cat ImageSets/Main/val.txt
3384827.jpg
3384828.jpg
3384829.jpg
.
.
```

## Execution Instructions

### Training

- Download the source-trained model weights in source_model folder [Link](https://github.com/Vibashan/irg-sfda)

```angular2
CUDA_VISIBLE_DEVICES=$GPU_ID python tools/train_st_sfda_net.py \ 
--config-file configs/sfda/sfda_foggy.yaml --model-dir $PATH TO SOURCE_TRAINED_MODEL
```

### Evaluation

- After training, load the teacher model weights and perform evaluation using
```angular2
CUDA_VISIBLE_DEVICES=$GPU_ID python tools/plain_test_net.py --eval-only \ 
--config-file configs/sfda/foggy_baseline.yaml --model-dir $PATH TO CHECKPOINT
```

## Acknowledgement

We thank the developers and authors of [Detectron](https://github.com/facebookresearch/detectron2) and [IRG-SFDA](https://github.com/Vibashan/irg-sfda) for releasing their helpful codebases.
