# Instance Relation Graph Guided Source-Free Domain Adaptive Object Detection [CVPR 2023]

[![Framework: PyTorch](https://img.shields.io/badge/Framework-PyTorch-orange.svg)](https://pytorch.org/) 

[Vibashan VS](https://vibashan.github.io/), [Poojan Oza](https://www.linkedin.com/in/poojan-oza-a7b68350/), [Vishal M Patel](https://scholar.google.com/citations?user=AkEXTbIAAAAJ&hl=en)

[[`Project Page`](https://viudomain.github.io/irg-sfda-web/)] [[`arXiv`](https://arxiv.org/abs/2203.15793)] [[`pdf`](https://arxiv.org/pdf/2203.15793.pdf)] [[`Slides`](https://docs.google.com/presentation/d/1AMVnharvA3A_UCXIf6XrLEiGG_sOF0YE/edit?usp=sharing&ouid=115004586392986149446&rtpof=true&sd=true)] [[`BibTeX`](https://github.com/Vibashan/irg-sfda/blob/main/reference.bib)]

<p align="center">
  <img src="imgs/Archi.png" width="800"/>
</p>

#### Contributions
- We investigate the problem of source-free domain adaptation for object detection and identify some of the major challenges that need to be addressed.
- We introduced an Instance Relation Graph (IRG) framework to model the relationship between proposals generated by the region proposal network.
- We propose a contrastive loss which is guided by the IRG network to improve the instance-level representations for the target data.

## Contents
1. [Installation Instructions](#installation-instructions)
2. [Dataset Preparation](#dataset-preparation)
3. [Execution Instructions](#execution-instructions)
    - [Training](#training)
    - [Evaluation](#evaluation)
4. [Results](#results)
5. [Citation](#citation)

## Installation Instructions
- We use Python 3.6, PyTorch 1.9.0 (CUDA 10.2 build).
- The codebase is built on [Detectron](https://github.com/facebookresearch/detectron2).

```angular2
conda create -n irg_sfda python=3.6

Conda activate irg_sfda

conda install pytorch==1.9.0 torchvision==0.10.0 torchaudio==0.9.0 cudatoolkit=10.2 -c pytorch

cd irg-sfda
pip install -r requirements.txt

## Make sure you have GCC and G++ version <=8.0
cd ..
python -m pip install -e irg-sfda

```



## Dataset Preparation

* **PASCAL_VOC 07+12**: Please follow the instructions in [py-faster-rcnn](https://github.com/rbgirshick/py-faster-rcnn#beyond-the-demo-installation-for-training-and-testing-models) to prepare VOC datasets.
* **Clipart, WaterColor**: Dataset preparation instruction link [Cross Domain Detection ](https://github.com/naoto0804/cross-domain-detection/tree/master/datasets). Images translated by Cyclegan are available in the website.
* **Sim10k**: Website [Sim10k](https://fcav.engin.umich.edu/sim-dataset/)
* **CitysScape, FoggyCityscape**: Download website [Cityscape](https://www.cityscapes-dataset.com/), see dataset preparation code in [DA-Faster RCNN](https://github.com/tiancity-NJU/da-faster-rcnn-PyTorch)

Download all the dataset into "./dataset" folder.
The codes are written to fit for the format of PASCAL_VOC.
For example, the dataset [Sim10k](https://fcav.engin.umich.edu/sim-dataset/) is stored as follows.

```
$ cd ./dataset/Sim10k/VOC2012/
$ ls
Annotations  ImageSets  JPEGImages
$ cat ImageSets/Main/val.txt
3384827.jpg
3384828.jpg
3384829.jpg
.
.
```

## Execution Instructions

### Training

- Download the source-trained model weights in source_model folder [Link](https://drive.google.com/drive/folders/1Aia6wCHPCHGsVk8yQtuByxEyoYm1KfQq?usp=sharing)

```angular2
CUDA_VISIBLE_DEVICES=$GPU_ID python tools/train_st_sfda_net.py \ 
--config-file configs/sfda/sfda_foggy.yaml --model-dir ./source_model/cityscape_baseline/model_final.pth
```

### Evaluation

- After training, load the teacher model weights and perform evaluation using
```angular2
CUDA_VISIBLE_DEVICES=$GPU_ID python tools/plain_test_net.py --eval-only \ 
--config-file configs/sfda/foggy_baseline.yaml --model-dir $PATH TO CHECKPOINT
```

## Results

- Pre-trained models can be downloaded from [Link](https://drive.google.com/drive/folders/1RJzz4u9WV8mrcAdz_Z7_k-SSQ7SPO9hE?usp=share_link).


## Citation

If you found IRG SFDA useful in your research, please consider starring ⭐ us on GitHub and citing 📚 us in your research!

```bibtex
@inproceedings{vs2023instance,
  title={Instance relation graph guided source-free domain adaptive object detection},
  author={VS, Vibashan and Oza, Poojan and Patel, Vishal M},
  booktitle={Proceedings of the IEEE/CVF Conference on Computer Vision and Pattern Recognition},
  pages={3520--3530},
  year={2023}
}
```

## Acknowledgement

We thank the developers and authors of [Detectron](https://github.com/facebookresearch/detectron2) for releasing their helpful codebases.
