
# Tanh Works Better with Asymmetry

This repository is the official implementation of [Tanh Works Better with Asymmetry] 

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Training

To train the Convention model with the shifted Tanh, run this command: 

```train
bash vgg16_11_Convention_shifted_tanh_train.sh
```

To train the NWDBN model with the Tanh, run this command: 

```train
bash vgg16_11_NWDBN_train.sh
```

>📋  Argument desctiption in the bash script

--arch VGG 
: Architecture type [VGG | MobileNet | PreActResNet]

--depth_wide 16
: Depth for Architecture [16 (for VGG) | 18 (for PreActResNet) | 34 (for PreActResNet)]

--vgg_cut_block 5 
: The number of Cut-off parameter for VGG [5 generates the VGG16_11 model, i.e., 16-5]

--operation_order cba
: Layer order [cba (for Convention) | cab (for Swap )]

--activation_type shifted_tanh
: Activation function type [tanh | relu | shifted_tanh]

--gamma_decay 0.0 --beta_decay 0.0
: The intensity of weight decay for the affine parameters in BN

## Evaluation

To evaluate the Convention VGG16_11 model, run: 

```eval
bash vgg16_11_Convention_evaluate.sh
```

To evaluate the Swap VGG16_11 model, run: 

```eval
bash vgg16_11_Swap_evaluate.sh
```

## Measurements

To measure saturation, run: 

```measure
bash vgg16_11_Convention_saturation.sh
bash vgg16_11_Swap_saturation.sh
```

To measure asymmetry, run: 

```
- vgg16_11_Convention_skewness.sh
- vgg16_11_Swap_skewness.sh
```

To measure sparsity, run:

```
bash vgg16_11_Convention_sparsity.sh
bash vgg16_11_Swap_sparsity.sh
```

>📋  Argument desctiption in the bash script

--saturation
: measuring option for saturation

--skewness
: measuring option for asymmetry

--sparsity
: measuring option for sparsity


## Pre-trained Models

Our pretrained model, VGG16_11 Convention with Tanh and VGG16_11 Swap with Tanh, are in the saved_models/paper.
