# GUI-G1: Understanding R1-Zero-Like Training for Visual Grounding in GUI Agents

<div style="width: 100%; margin: 0;">
  <img src="./src/assets/workflow.png" style="width: 100%; display: block;" />
</div>

> This repository is based on [VLM-R1](https://github.com/omlab/VLM-R1), with several improvements and adaptations for our use case, especially on **Template**, **Reward Functions**, and **GRPO Objective**.

---

## 🔧 Major Modifications of GUI-G1

* Introduced a **Fast Thinking Template** that requires no model reasoning, accelerating training and inference
* Utilized diverse **reward functions (Hit, IoU, Box)** to prevent reward hacking and achieve multi-objective optimization
* Removed **length correction** from the GRPO objective and added a **difficulty coefficient** to enhance model robustness
---

## Setup

```bash
conda create -n myproject python=3.10
conda activate myproject
bash setup.sh
```

---

Follow the steps below to prepare data and train the model:

> 1. \[Data preparation instructions customized for your setup]
> 2. \[Reference to your configuration files or modified scripts]
> 3. Use the following command to launch training:

```bash
bash src/open-r1-multimodal/run_scripts/run.sh
```

---

## Results

| Model         | ScreenSpot | ScreenSPot-Pro |
| ------------- | --------------- | ------------------- |
| InfiGUI-R1-3B  |   87.5      |    35.7           |
| **GUI-G1-3B** |    **90.3**    | **37.1**            |

---

## Acknowledgements

This repository builds upon the great work from:

* [VLM-R1](https://github.com/omlab/VLM-R1)

We thank the authors for their open-source contributions.

---
