default_config = {
    "transition_params": {
        "use_weight_decay": True,
        "optimizer_class": "Adam",
        "learning_rate": 0.001,
        "inc_var_loss": True,
        "model": {
            "hidden_dims": [128, 128],
            "decay_weights": [0.00005, 0.000075, 0.0001],
            "act_fn": "swish",
            "out_act_fn": "identity",
            "num_elite": 5,
            "ensemble_size": 5
        }
    },
    "primorl_params": {
        "max_epoch": 400,
        "rollout_batch_size": 50000,
        "rollout_mini_batch_size": 10000,
        "model_retain_epochs": 1,
        "num_env_steps_per_epoch": 1000,
        "train_model_interval": 250,
        "max_trajectory_length": 1000,
        "eval_interval": 1000,
        "num_eval_trajectories": 10,
        "snapshot_interval": 2000,
    }
}
