from prompt_templates import TASK_DESC_PROMPT, DIRECT_ANSWER_PROMPT, GUIDED_ANSWER_PROMPT, BASE_MODEL_API_URL, BASE_MODEL_NAME
from main_pipeline import gpt_call

def generate_task_description(question: str) -> str:
    return gpt_call(TASK_DESC_PROMPT.format(question=question))

def answer_question_directly(question: str) -> str:
    return gpt_call(DIRECT_ANSWER_PROMPT.format(question=question))

def answer_with_principles(question: str, principles: list) -> str:
    principle_text = "\n".join(principles)
    return gpt_call(GUIDED_ANSWER_PROMPT.format(question=question, principle_text=principle_text))
