from main_pipeline import gpt_call
from prompt_templates import PRINCIPLE_PROMPT, DIFF_PROMPT, BASE_MODEL_API_URL, STRONG_MODEL_API_URL

# CDE process.
def generate_difference_list(question: str, pred: str, label: str) -> str:
    return gpt_call(DIFF_PROMPT.format(question=question, pred=pred, label=label))


def generate_principles(question: str, diff_list: str, model="weak") -> str:
    prompt = PRINCIPLE_PROMPT.format(question=question, diff_list=diff_list)
    if model == "strong":
        return gpt_call(STRONG_MODEL_API_URL, prompt)
    else:
        return gpt_call(BASE_MODEL_API_URL, prompt)

