import argparse

from lang_hrl.utils.sweeper import Experiment, Sweeper, Hardware

if __name__ == "__main__":

    parser = argparse.ArgumentParser()
    parser.add_argument('--experiment', '-e', type=str, required=True, help="Path to the the experiment file.")
    parser.add_argument('--path', '-p', type=str, required=True, help="Base output path for experiments.")
    parser.add_argument('--cpus', '-c', type=str, nargs='+', default=None)
    parser.add_argument('--gpus', '-g', type=int, nargs='+', default=None)
    args = parser.parse_args()

    hardware = Hardware(args.gpus, args.cpus)
    experiment = Experiment.load(args.experiment)
    sweeper = Sweeper(experiment, hardware, args.path)
    sweeper.run()
