import argparse
import os
import tempfile
import subprocess

from lang_hrl.utils.trainer import Config

parser = argparse.ArgumentParser()
parser.add_argument("--path", type=str)
parser.add_argument("--save-path", type=str, default="../results/ayh_hrl_convert")
parser.add_argument('--gpus', '-g', type=int, nargs='+', default=None)

args = parser.parse_args()

paths = [os.path.join(args.path, d) for d in os.listdir(args.path)]
processes = []

for i, path in enumerate(paths):
    config = Config.load(os.path.join(path, "config.yaml"))
    # Overwrite specific values
    config['alg_kwargs']['lang_coeff'] = 0.0
    config['alg_kwargs']['pretraining'] = False
    config['alg_kwargs']['checkpoint'] = os.path.join(path, "best_model.pt")
    config['train_kwargs']['validation_metric'] = 'accuracy'

    _, config_path = tempfile.mkstemp(text=True, prefix='config', suffix='.json')
    config.save(config_path)
    command_list = [
        'python', '/home/ANONYMIZED/lang_hrl/lang_hrl/utils/train_subproc.py',
        '--config', config_path,
        '--save-path', os.path.join(args.save_path, os.path.basename(path))
        ]
    command_list.extend(['--device', 'cuda'])
    gpu = args.gpus[i % len(args.gpu_list)]
    env = os.environ
    env["CUDA_VISIBLE_DEVICES"] = str(gpu) # TODO: this doesn't support multi-gpu
    proc = subprocess.Popen(command_list, env=env)
    processes.append(proc)


