## ConvSSM (Paper #4031) Code

For ease of viewing, this folder contains the core code for ConvS5 and the ConvLSTM, S5 and Transformer baselines
used in the paper. A more complete repo will be publicly released after the review process. 


The Transformer code is based on the implementation from the TECO [repo](https://github.com/wilson1yan/teco), [Paper](https://arxiv.org/abs/2210.02396).

The S5 code is based on the implementation from the S5 [repo](https://github.com/lindermanlab/S5), [Paper](https://arxiv.org/abs/2208.04933).

## Repository Structure
```commandline
src/
    models/
        convLSTM/
            layers.py             Implementation of a stack of ConvLSTM layers
            scans.py              Implementation of sequential scan of ConvLSTM
            ssm.py                Core code for applying a single ConvLSTM
        convS5/
            conv_ops.py           Convolution related helper functions
            diagonal_convSSM.py   Core code for applying a single ConvS5
            diagonal_scans.py     Implementation of parallel and sequential scan of ConvS5
            layers.py             Implementation of a stack of ConvS5 layers
        S5/
            diagonal_scans.py     Implementation of parallel and sequential scan of S5
            diagonal_SSM.py       Core code for applying a single S5
            layers.py             Implementation of a stack of S5 layers
        Transformer/
            transformer.py        Transformer related implementation code
README.MD
```

