
import argparse





def import_game_config():
    
    parser = argparse.ArgumentParser(description='config for qnyh 1v1 game PVE')
     #
    parser.add_argument('--env-name', default='randomWalk-v0',#"CartPole-v1",
                        help='Mujoco Gym environment (default: HalfCheetah-v1)')
    parser.add_argument('--policy', default="Gaussian",
                        help='Policy Type: Gaussian | Deterministic (default: Gaussian)')
    parser.add_argument('--eval', type=bool, default=True, help='Evaluates a policy a policy every 10 episode (default: True)')
    parser.add_argument('--gamma', type=float, default=0.99, metavar='G',
                        help='discount factor for reward (default: 0.99)')
    parser.add_argument('--tau', type=float, default=0.005, metavar='G',
                        help='target smoothing coefficient(τ) (default: 0.005)')
    parser.add_argument('--lr', type=float, default=0.0003, metavar='G',
                        help='learning rate (default: 0.0003)')
    parser.add_argument('--alpha', type=float, default=0.2, metavar='G',
                        help='Temperature parameter α determines the relative importance of the entropy\
                                term against the reward (default: 0.2)')
    parser.add_argument('--automatic_entropy_tuning', type=bool, default=True, metavar='G',
                        help='Automaically adjust α (default: False)')
    parser.add_argument('--seed', type=int, default=123456, metavar='N',
                        help='random seed (default: 123456)')
    parser.add_argument('--batch_size', type=int, default=256, metavar='N',
                        help='batch size (default: 256)')
    parser.add_argument('--her_batch_size', type=int, default=256, metavar='N',
help='her batch size (default: 10)')
    parser.add_argument('--num_steps', type=int, default=1000001, metavar='N',
                        help='maximum number of steps (default: 1000000)')
    parser.add_argument('--hidden_size', type=int, default=256, metavar='N',
                        help='hidden size (default: 256)')
    parser.add_argument('--updates_per_step', type=int, default=1, metavar='N',
                        help='model updates per simulator step (default: 1)')
    parser.add_argument('--start_steps', type=int, default=10000, metavar='N',#10000
                        help='Steps sampling random actions (default: 10000)')
    parser.add_argument('--target_update_interval', type=int, default=1, metavar='N',
                        help='Value target update per no. of updates per step (default: 1)')
    parser.add_argument('--replay_size', type=int, default=1000000, metavar='N',#1000000
                        help='size of replay buffer (default: 10000000)')
    parser.add_argument('--cuda', action="store_false",
                        help='run on CUDA (default: True)')
    parser.add_argument('--Alice_cuda', action="store_false",
                        help='run on CUDA (default: True)')
    parser.add_argument('--load_model', action="store_true",
                        help='run on CUDA (default: False)')
    parser.add_argument('--experiment_name', default='test', help='Name of this experiment')
    parser.add_argument('--demonstration',action='store_true',help='demonstrate the trained model, default=False')
    parser.add_argument('--max_timesteps',default=100,help="Max step num of each episode")
    parser.add_argument('--her_flag',action='store_true',help="default not use her reward")
    parser.add_argument('--start_cpu',default=1,type= int, help='the default start cpu of the experiment')

    parser.add_argument('--mainagent',default='Alice', help='the default start cpu of the experiment')
    parser.add_argument('--agentnum',default=4,type= int, help='the default agent num of the experiment')#4
    parser.add_argument('--headnum',default=5,type= int, help='the default head num of the experiment')
    parser.add_argument('--ensamble_num',default=2,type= int, help='the default ensamble num of the experiment')
    parser.add_argument('--eta',default=-1.0,type= float, help='which used in EDAC,-1.0 means close this service ')
    parser.add_argument('--shaping', action="store_true",help='use the shaping in training')
    #parser.add_argument('--eta',default=0.001,type= float, help='which used in EDAC,-1.0 means close this service ')
    


    #her
    parser.add_argument('--replay-k', type=int, default=4, help='ratio to be replace')
    parser.add_argument('--replay-strategy', type=str, default='future', help='the HER strategy')
    #Env qnyh
    parser.add_argument('--school',default='JiaShi',
    help='JiaShi, SheShou, FangShi can be choosed')
    parser.add_argument('--select_skill',action='store_true',
    help=' default is True')
    parser.add_argument('--print_game_log',action='store_true',
    help='default not print the game log default=False')
    parser.add_argument('--hard_AI',action='store_true',
    help='default not open hard style')
    parser.add_argument('--print_action_list',action='store_true',
    help='default=False')
    parser.add_argument('--classify',action='store_true',help='default=false')
                    
    return parser.parse_args()#namespace=get_map('config')

args = import_game_config()
map= {'args':args}

def set_map(key, value):
    map[key] = value
def del_map(key):
    try:
        del map[key]
    except KeyError:
        print ("key:'"+str(key)+"'  不存在")
def get_map(key):
    try:
        if key in "all":
            return map
        return map[key]
    except KeyError as e:
        print ("key:'"+str(key)+"'  不存在")
