"""
http://incompleteideas.net/sutton/MountainCar/MountainCar1.cp
permalink: https://perma.cc/6Z2N-PFWC
"""
import math
import sys,time
import numpy as np

import gym
from gym import spaces
from gym.utils import seeding


class RandomWalk(gym.Env):
  
    # metadata = {
    #     'render.modes': ['human', 'rgb_array'],
    #     'video.frames_per_second': 30
    # }

    def __init__(self, len=3):

        self.action_space = spaces.Discrete(2)
        self.observation_space =spaces.Discrete(2*len+1)
        self.pos=0
        self.goal=len


        self.seed()

    def seed(self, seed=None):
        self.np_random, seed = seeding.np_random(seed)
        return [seed]

    def step(self, action):
        assert self.action_space.contains(action), "%r (%s) invalid" % (action, type(action))
        
        self.pos = self.pos + 1 if action==1 else self.pos-1
        if self.pos>self.goal or self.pos<-self.goal:
            print("warrning!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
        done = bool(
            self.pos > int(self.goal-1)
            or self.pos<int(-1*self.goal+1)#-self.observation_space.n# and velocity >= self.goal_velocity
        )
        reward = -0.1*(self.goal-self.pos+1) if self.pos < self.goal else 100.0#self.pos -10 #

        self.state = [self.pos]
        return np.array(self.state), reward, done, {'forward_r':-(self.goal-self.pos),'away_r':(self.pos+self.goal)}

    def reset(self):
        self.pos = 0
        self.state=[self.pos]
        return np.array(self.state)


    def render(self, mode='human'):
        tab_len=5
        index=[ str(i-self.observation_space.n//2).center(tab_len) for i in range(self.observation_space.n)]
        map=[]
        if self.observation_space.n >self.pos+self.observation_space.n//2>=0:
            for i in range(self.observation_space.n):
                if i!=self.pos+self.observation_space.n//2:
                    map+=['-'.center(tab_len)]
                else:  map+=['I'.center(tab_len)]
        else:
            map=['-'.center(tab_len) *self.observation_space.n]
        #map[self.pos]='I'.center(tab_len)
        #text.center(20,"*")

        #print('')
        sys.stdout.write("\r")  # 清空终端并清空缓冲区
        sys.stdout.write(''.join(index))
        sys.stdout.write("\n") 
        sys.stdout.write(''.join(map)) # 往缓冲区里写数据
        sys.stdout.write("\n") 
        sys.stdout.flush() # 将缓冲区里的数据刷新到终端，但是不会清空缓冲区
        time.sleep(0.1)
        
       # return self.viewer.render(return_rgb_array=mode == 'rgb_array')

  

    def close(self):
        pass
        # if self.viewer:
        #     self.viewer.close()
        #     self.viewer = None
