(define (domain Keva)
(:requirements :strips :typing :equality :conditional-effects :existential-preconditions :universal-preconditions)
(:types 
	goalLoc
	plank
	gripper
)

(:constants 
	goalLoc_Const - goalLoc
 )

(:predicates 
	(gripper_plank_0 ?x - gripper ?y - plank)
	(gripper_plank_1 ?x - gripper ?y - plank)
	(gripper_plank_2 ?x - gripper ?y - plank)
	(plank_plank_0 ?x - plank ?y - plank)
	(plank_plank_1 ?x - plank ?y - plank)
	(plank_plank_2 ?x - plank ?y - plank)
	(plank_plank_3 ?x - plank ?y - plank)
	(plank_plank_4 ?x - plank ?y - plank)
	(plank_plank_5 ?x - plank ?y - plank)
	(plank_plank_6 ?x - plank ?y - plank)
	(plank_plank_7 ?x - plank ?y - plank)
	(plank_plank_8 ?x - plank ?y - plank)
	(plank_plank_9 ?x - plank ?y - plank)
	(goalLoc_plank_0 ?x - goalLoc ?y - plank)
	(goalLoc_plank_1 ?x - goalLoc ?y - plank)
	(clear3_plank_plank_2 ?x - plank)
	(clear3_gripper_plank_2 ?x - gripper)
	(clear3_plank_plank_6 ?x - plank)
	(clear3_plank_plank_8 ?x - plank)
	(clear3_plank_plank_5 ?x - plank)
	(clear3_plank_plank_7 ?x - plank)
	(clear3_plank_plank_9 ?x - plank)
	(clear3_plank_plank_4 ?x - plank)
	(clear3_gripper_plank_1 ?x - gripper)
	(clear3_plank_plank_1 ?x - plank)
	(clear3_plank_plank_3 ?x - plank)
)

(:action a1 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p2)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p2)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(clear3_plank_plank_4 ?plank_p1) 
	(clear3_plank_plank_4 ?plank_p2) 
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p1) 
	(plank_plank_4 ?plank_p2 ?plank_p1) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p1))
	(not (plank_plank_0 ?plank_p2 ?plank_p1))
	(not (plank_plank_1 ?plank_p2 ?plank_p1))
	(not (plank_plank_2 ?plank_p2 ?plank_p1))
	(not (plank_plank_3 ?plank_p2 ?plank_p1))
	(not (plank_plank_5 ?plank_p2 ?plank_p1))
	(not (plank_plank_6 ?plank_p2 ?plank_p1))
	(not (plank_plank_7 ?plank_p2 ?plank_p1))
	(not (plank_plank_8 ?plank_p2 ?plank_p1))
	(not (plank_plank_9 ?plank_p2 ?plank_p1))
	(not (clear3_plank_plank_4 ?plank_p2)) 
 ) 
)

(:action a2 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_4 ?plank_p3 ?plank_p1)
	(clear3_plank_plank_1 ?plank_p1) 
	(clear3_plank_plank_1 ?plank_p2) 
	(clear3_plank_plank_1 ?plank_p3) 
	(clear3_plank_plank_3 ?plank_p1) 
	(clear3_plank_plank_3 ?plank_p2) 
	(clear3_plank_plank_3 ?plank_p3) 
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_1 ?plank_p1 ?plank_p2) 
	(plank_plank_3 ?plank_p3 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (clear3_plank_plank_1 ?plank_p1)) 
	(not (clear3_plank_plank_3 ?plank_p3)) 
 ) 
)

(:action a3 
:parameters ( ?plank_p1 - plank  ?gripper_p1 - gripper )
:precondition (and 
	(gripper_plank_2 ?gripper_p1 ?plank_p1)
	(clear3_gripper_plank_1 ?gripper_p1) 
) 
:effect (and 
 	(gripper_plank_1 ?gripper_p1 ?plank_p1) 
	(not (gripper_plank_0 ?gripper_p1 ?plank_p1))
	(not (gripper_plank_2 ?gripper_p1 ?plank_p1))
	(clear3_gripper_plank_2 ?gripper_p1) 
	(not (clear3_gripper_plank_1 ?gripper_p1)) 
 ) 
)

(:action a4 
:parameters ( ?plank_p1 - plank  ?gripper_p1 - gripper )
:precondition (and 
	(gripper_plank_0 ?gripper_p1 ?plank_p1)
	(clear3_gripper_plank_1 ?gripper_p1) 
	(clear3_gripper_plank_2 ?gripper_p1) 
) 
:effect (and 
 	(gripper_plank_2 ?gripper_p1 ?plank_p1) 
	(not (gripper_plank_0 ?gripper_p1 ?plank_p1))
	(not (gripper_plank_1 ?gripper_p1 ?plank_p1))
	(not (clear3_gripper_plank_2 ?gripper_p1)) 
 ) 
)

(:action a5 
:parameters ( ?plank_p1 - plank  ?gripper_p1 - gripper )
:precondition (and 
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(gripper_plank_2 ?gripper_p1 ?plank_p1)
	(clear3_gripper_plank_1 ?gripper_p1) 
) 
:effect (and 
 	(gripper_plank_0 ?gripper_p1 ?plank_p1) 
	(not (gripper_plank_1 ?gripper_p1 ?plank_p1))
	(not (gripper_plank_2 ?gripper_p1 ?plank_p1))
	(clear3_gripper_plank_2 ?gripper_p1) 
 ) 
)

(:action a6 
:parameters ( ?plank_p1 - plank  ?gripper_p1 - gripper )
:precondition (and 
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(gripper_plank_1 ?gripper_p1 ?plank_p1)
	(clear3_gripper_plank_2 ?gripper_p1) 
) 
:effect (and 
 	(gripper_plank_2 ?gripper_p1 ?plank_p1) 
	(not (gripper_plank_0 ?gripper_p1 ?plank_p1))
	(not (gripper_plank_1 ?gripper_p1 ?plank_p1))
	(clear3_gripper_plank_1 ?gripper_p1) 
	(not (clear3_gripper_plank_2 ?gripper_p1)) 
 ) 
)

(:action a7 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_4 ?plank_p3 ?plank_p1)
	(clear3_plank_plank_8 ?plank_p1) 
	(clear3_plank_plank_8 ?plank_p2) 
	(clear3_plank_plank_8 ?plank_p3) 
	(clear3_plank_plank_9 ?plank_p1) 
	(clear3_plank_plank_9 ?plank_p2) 
	(clear3_plank_plank_9 ?plank_p3) 
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_8 ?plank_p1 ?plank_p2) 
	(plank_plank_9 ?plank_p3 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (clear3_plank_plank_8 ?plank_p1)) 
	(not (clear3_plank_plank_9 ?plank_p3)) 
 ) 
)

(:action a8 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_4 ?plank_p3 ?plank_p1)
	(clear3_plank_plank_2 ?plank_p1) 
	(clear3_plank_plank_2 ?plank_p2) 
	(clear3_plank_plank_2 ?plank_p3) 
	(clear3_plank_plank_6 ?plank_p1) 
	(clear3_plank_plank_6 ?plank_p2) 
	(clear3_plank_plank_6 ?plank_p3) 
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_2 ?plank_p3 ?plank_p2) 
	(plank_plank_6 ?plank_p1 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (clear3_plank_plank_2 ?plank_p3)) 
	(not (clear3_plank_plank_6 ?plank_p1)) 
 ) 
)

(:action a9 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p2)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p2)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(clear3_plank_plank_5 ?plank_p1) 
	(clear3_plank_plank_5 ?plank_p2) 
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p1) 
	(plank_plank_5 ?plank_p2 ?plank_p1) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p1))
	(not (plank_plank_0 ?plank_p2 ?plank_p1))
	(not (plank_plank_1 ?plank_p2 ?plank_p1))
	(not (plank_plank_2 ?plank_p2 ?plank_p1))
	(not (plank_plank_3 ?plank_p2 ?plank_p1))
	(not (plank_plank_4 ?plank_p2 ?plank_p1))
	(not (plank_plank_6 ?plank_p2 ?plank_p1))
	(not (plank_plank_7 ?plank_p2 ?plank_p1))
	(not (plank_plank_8 ?plank_p2 ?plank_p1))
	(not (plank_plank_9 ?plank_p2 ?plank_p1))
	(not (clear3_plank_plank_5 ?plank_p2)) 
 ) 
)

(:action a10 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p2)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p2)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(clear3_plank_plank_7 ?plank_p1) 
	(clear3_plank_plank_7 ?plank_p2) 
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p1) 
	(plank_plank_7 ?plank_p2 ?plank_p1) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p1))
	(not (plank_plank_0 ?plank_p2 ?plank_p1))
	(not (plank_plank_1 ?plank_p2 ?plank_p1))
	(not (plank_plank_2 ?plank_p2 ?plank_p1))
	(not (plank_plank_3 ?plank_p2 ?plank_p1))
	(not (plank_plank_4 ?plank_p2 ?plank_p1))
	(not (plank_plank_5 ?plank_p2 ?plank_p1))
	(not (plank_plank_6 ?plank_p2 ?plank_p1))
	(not (plank_plank_8 ?plank_p2 ?plank_p1))
	(not (plank_plank_9 ?plank_p2 ?plank_p1))
	(not (clear3_plank_plank_7 ?plank_p2)) 
 ) 
)

(:action a11 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p1 - plank )
:precondition (and 
	(goalLoc_plank_0 goalLoc_Const ?plank_p1)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p1)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p1) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p1))
 ) 
)

(:action a12 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p1)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_7 ?plank_p1 ?plank_p3)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_4 ?plank_p3 ?plank_p2) 
	(plank_plank_5 ?plank_p1 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (clear3_plank_plank_4 ?plank_p3)) 
	(not (clear3_plank_plank_5 ?plank_p1)) 
 ) 
)

(:action a13 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_4 ?plank_p3 ?plank_p1)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_8 ?plank_p1 ?plank_p2) 
	(plank_plank_9 ?plank_p3 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (clear3_plank_plank_8 ?plank_p1)) 
	(not (clear3_plank_plank_9 ?plank_p3)) 
 ) 
)

(:action a14 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p4 - plank  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p4 ?plank_p3))
	(not (= ?plank_p4 ?plank_p2))
	(not (= ?plank_p4 ?plank_p1))
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(goalLoc_plank_1 goalLoc_Const ?plank_p4)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p4)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p4)
	(plank_plank_0 ?plank_p3 ?plank_p1)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_0 ?plank_p4 ?plank_p1)
	(plank_plank_0 ?plank_p4 ?plank_p2)
	(plank_plank_0 ?plank_p4 ?plank_p3)
	(plank_plank_0 ?plank_p4 ?plank_p4)
	(plank_plank_2 ?plank_p1 ?plank_p4)
	(plank_plank_4 ?plank_p1 ?plank_p3)
	(plank_plank_6 ?plank_p3 ?plank_p4)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_1 ?plank_p3 ?plank_p2) 
	(plank_plank_3 ?plank_p1 ?plank_p2) 
	(plank_plank_4 ?plank_p4 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_0 ?plank_p4 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p4 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p4 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p4 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p4 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p4 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p4 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p4 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p4 ?plank_p2))
	(not (clear3_plank_plank_1 ?plank_p3)) 
	(not (clear3_plank_plank_3 ?plank_p1)) 
	(not (clear3_plank_plank_4 ?plank_p4)) 
 ) 
)

(:action a15 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p1)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_4 ?plank_p1 ?plank_p3)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_1 ?plank_p3 ?plank_p2) 
	(plank_plank_3 ?plank_p1 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (clear3_plank_plank_1 ?plank_p3)) 
	(not (clear3_plank_plank_3 ?plank_p1)) 
 ) 
)

(:action a16 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p4 - plank  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p4 ?plank_p3))
	(not (= ?plank_p4 ?plank_p2))
	(not (= ?plank_p4 ?plank_p1))
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(goalLoc_plank_1 goalLoc_Const ?plank_p4)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p4)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p3)
	(plank_plank_0 ?plank_p1 ?plank_p4)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p4)
	(plank_plank_0 ?plank_p3 ?plank_p1)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p4)
	(plank_plank_0 ?plank_p4 ?plank_p2)
	(plank_plank_0 ?plank_p4 ?plank_p3)
	(plank_plank_0 ?plank_p4 ?plank_p4)
	(plank_plank_4 ?plank_p4 ?plank_p1)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_2 ?plank_p4 ?plank_p2) 
	(plank_plank_4 ?plank_p3 ?plank_p2) 
	(plank_plank_6 ?plank_p1 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_0 ?plank_p4 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p4 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p4 ?plank_p2))
	(not (plank_plank_4 ?plank_p1 ?plank_p2))
	(not (plank_plank_4 ?plank_p4 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p4 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p4 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_7 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p4 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_8 ?plank_p4 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p4 ?plank_p2))
	(not (clear3_plank_plank_2 ?plank_p4)) 
	(not (clear3_plank_plank_4 ?plank_p3)) 
	(not (clear3_plank_plank_6 ?plank_p1)) 
 ) 
)

(:action a17 
:parameters ( ?gripper_extra_p1 - gripper  ?plank_p3 - plank  ?plank_p2 - plank  ?plank_p1 - plank )
:precondition (and 
	(not (= ?plank_p3 ?plank_p2))
	(not (= ?plank_p3 ?plank_p1))
	(not (= ?plank_p2 ?plank_p1))
	(goalLoc_plank_0 goalLoc_Const ?plank_p2)
	(goalLoc_plank_1 goalLoc_Const ?plank_p1)
	(goalLoc_plank_1 goalLoc_Const ?plank_p3)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p1)
	(gripper_plank_0 ?gripper_extra_p1 ?plank_p3)
	(gripper_plank_1 ?gripper_extra_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p1)
	(plank_plank_0 ?plank_p1 ?plank_p2)
	(plank_plank_0 ?plank_p1 ?plank_p3)
	(plank_plank_0 ?plank_p2 ?plank_p1)
	(plank_plank_0 ?plank_p2 ?plank_p2)
	(plank_plank_0 ?plank_p2 ?plank_p3)
	(plank_plank_0 ?plank_p3 ?plank_p1)
	(plank_plank_0 ?plank_p3 ?plank_p2)
	(plank_plank_0 ?plank_p3 ?plank_p3)
) 
:effect (and 
 	(goalLoc_plank_1 goalLoc_Const ?plank_p2) 
	(plank_plank_4 ?plank_p1 ?plank_p2) 
	(plank_plank_7 ?plank_p3 ?plank_p2) 
	(not (goalLoc_plank_0 goalLoc_Const ?plank_p2))
	(not (plank_plank_0 ?plank_p1 ?plank_p2))
	(not (plank_plank_0 ?plank_p3 ?plank_p2))
	(not (plank_plank_1 ?plank_p1 ?plank_p2))
	(not (plank_plank_1 ?plank_p3 ?plank_p2))
	(not (plank_plank_2 ?plank_p1 ?plank_p2))
	(not (plank_plank_2 ?plank_p3 ?plank_p2))
	(not (plank_plank_3 ?plank_p1 ?plank_p2))
	(not (plank_plank_3 ?plank_p3 ?plank_p2))
	(not (plank_plank_4 ?plank_p3 ?plank_p2))
	(not (plank_plank_5 ?plank_p1 ?plank_p2))
	(not (plank_plank_5 ?plank_p3 ?plank_p2))
	(not (plank_plank_6 ?plank_p1 ?plank_p2))
	(not (plank_plank_6 ?plank_p3 ?plank_p2))
	(not (plank_plank_7 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p1 ?plank_p2))
	(not (plank_plank_8 ?plank_p3 ?plank_p2))
	(not (plank_plank_9 ?plank_p1 ?plank_p2))
	(not (plank_plank_9 ?plank_p3 ?plank_p2))
	(not (clear3_plank_plank_4 ?plank_p1)) 
	(not (clear3_plank_plank_7 ?plank_p3)) 
 ) 
)


)