#!/usr/bin/bash
export CUDA_VISIBLE_DEVICES=0,1,2,3
export TORCH_DISTRIBUTED_DEBUG=INFO

/usr/bin/python -u -m torch.distributed.launch --master_port=1118 --nproc_per_node=3 --use_env \
 main_train.py --batch_size 5 --accum_iter 1 --stage 1 \
 --epochs 200 --split_epoch 1 --warmup_epochs 0 --lr 1e-4 --min_lr 1e-6 --weight_decay 0.05 \
 --vit_path google/vit-base-patch16-224 \
 --llama_path "./CKPTS/Llama-3.2-1B-Instruct/original" \
 --output_dir "./ckpts/pretrain_llama3.2_1B_8331_raw_data" --max_words 300 --llama_type llama3  \
 --model_type cardio_llama --add_special_token \
 --retrain --model_ckpt /data/qiuhui/code/ADReasoning/ckpts/pretrain_llama3.2_1B_8331_raw_data/checkpoint_24.pth

