#!/bin/bash

# 设置根目录
ROOT_DIR="/data/qiuhui/data/adni/adni_with_seg"

# 设置日志文件
LOG_FILE="processing_$(date +%Y%m%d_%H%M%S).log"

# 启动并行处理
echo "启动并行处理，日志输出到: $LOG_FILE"
python gen_six_mask.py "$ROOT_DIR" 2>&1 | tee "$LOG_FILE"

# 错误统计
ERROR_COUNT=$(grep -c "错误:" "$LOG_FILE")
SUCCESS_COUNT=$(grep -c "已处理" "$LOG_FILE" | tail -1 | awk '{print $3}')

echo "============================================================"
echo "处理完成! 成功: $SUCCESS_COUNT, 失败: $ERROR_COUNT"
echo "详细日志请查看: $LOG_FILE"
echo "============================================================"