from k_level_policy_gradients.src.algorithms.actor_critic.kfacmac import KFACMAC
from k_level_policy_gradients.src.utils.replay_memory import EpisodicReplayMemory
import torch.optim as optim


def setup_kfacmac_agent(mdp_info, idx_agent, agent_params, **kwargs):
    """
    Instantiates a KFACMAC mixing agent.
    """
    k_level = agent_params["k_level"]
    batch_size = agent_params["batch_size"]
    max_replay_size = agent_params["max_replay_size"]
    replay_memory = EpisodicReplayMemory(max_replay_size)
    target_update_frequency = agent_params["target_update_frequency"]
    tau = agent_params["tau"]
    warmup_replay_size = agent_params["warmup_replay_size"]
    target_update_mode = agent_params["target_update_mode"]
    assert target_update_mode == "soft" or target_update_mode == "hard"
    mixing_embed_dim = agent_params["mixing_embed_dim"]
    lr_actors = float(agent_params["lr_actors"])
    match agent_params["actor_optimizer_class"]:
        case "adam":
            actor_optimizer_class = optim.Adam
        case "rmsprop":
            actor_optimizer_class = optim.RMSprop
    actor_optimizer_params = {
        "class": actor_optimizer_class,
        "params": {"lr": lr_actors},
    }
    lr_critics = float(agent_params["lr_critics"])
    match agent_params["critic_optimizer_class"]:
        case "adam":
            critic_optimizer_class = optim.Adam
        case "rmsprop":
            critic_optimizer_class = optim.RMSprop
    critic_optimizer_params = {
        "class": critic_optimizer_class,
        "params": {"lr": lr_critics},
    }
    scale_critic_loss = agent_params["scale_critic_loss"]
    scale_actor_loss = agent_params["scale_actor_loss"]
    centralized_critic = agent_params["centralized_critic"]
    grad_norm_clip = agent_params["grad_norm_clip"]
    obs_last_action = agent_params["obs_last_action"]
    critic_obs_last_action = agent_params["critic_obs_last_action"]
    critic_agent_encoding = agent_params["critic_agent_encoding"]
    use_cuda = agent_params["use_cuda"]

    kfacmac = KFACMAC(
        k_level=k_level,
        mdp_info=mdp_info,
        idx_agent=idx_agent,
        batch_size=batch_size,
        replay_memory=replay_memory,
        target_update_frequency=target_update_frequency,
        tau=tau,
        warmup_replay_size=warmup_replay_size,
        target_update_mode=target_update_mode,
        mixing_embed_dim=mixing_embed_dim,
        actor_optimizer_params=actor_optimizer_params,
        critic_optimizer_params=critic_optimizer_params,
        scale_critic_loss=scale_critic_loss,
        scale_actor_loss=scale_actor_loss,
        centralized_critic=centralized_critic,
        grad_norm_clip=grad_norm_clip,
        obs_last_action=obs_last_action,
        critic_obs_last_action=critic_obs_last_action,
        critic_agent_encoding=critic_agent_encoding,
        host_agents=kwargs["host_agents"],
        use_cuda=use_cuda,
    )
    return kfacmac
