import ast
import re


def restore_slurm_dictionary(d):
    """
    Restores a dictionary that was modified by experiment_launcher
    d must be in list format, e.g.:

    d = [
    "{map_name:",
    "3m,",
    "horizon:",
    "None,",
    "gamma:",
    "0.99,",
    "difficulty:",
    "7,",
    "bool_render:",
    "False,",
    "use_cuda:",
    "False,",
    "n_total_iterations:",
    "100,",
    "n_steps_per_iteration:",
    "10000,",
    "n_features_actor:",
    "(400,300),",
    "n_steps_per_fit:",
    "None,",
    
    "n_episodes_per_fit:",
    "1,",
    "n_evaluation_episodes:",
    "10}",
    ]
    """

    # Join the list into a single string
    joined_str = "".join(d)

    # Remove braces to make it a valid dictionary format string
    joined_str = joined_str.strip("{}")

    # Use regex to split only at commas not within parentheses
    pairs = re.split(r",(?![^()]*\))", joined_str)
    dictionary = {}

    for pair in pairs:
        if ":" in pair:
            key, value = pair.split(":", 1)

            key = key.strip()
            value = value.strip()

            # Convert the value to appropriate Python types
            try:
                dictionary[key] = ast.literal_eval(value)
            except (ValueError, SyntaxError):
                dictionary[key] = value

    return dictionary
