import os
from line_profiler import LineProfiler


class Profiler:
    def __init__(self, logfile):
        self.logfile = logfile

        self.it = 0
        self.first_func = None
        self.first_func_found = False

        try:
            os.remove(self.logfile)
        except:
            pass

    def profile(self, func, *args, **kwargs):
        lp = LineProfiler()
        lp.add_function(func)
        lp_wrapper = lp(func)  # Profile run_iteration
        out = lp_wrapper(*args, **kwargs)

        if self.first_func_found and func == self.first_func:
            self.it += 1
            with open(self.logfile, "a") as f:
                f.write(f"Iteration: {self.it}\n")

        if not self.first_func_found:
            with open(self.logfile, "a") as f:
                f.write(f"Iteration: {self.it}\n")
            self.first_func = func
            self.first_func_found = True

        self.dump_stats(lp, self.it)

        return out

    def print_stats(self, lp):
        lp.print_stats()

    def dump_stats(self, lp, it):
        with open(self.logfile, "a") as f:
            lp.print_stats(stream=f)
