import timeit


class Timer:
    """
    Timing class which can be used to log the time taken for a function to run.
    """

    def __init__(self, logger=None):
        self.logger = logger

    def time_function(self, function_to_time, *args, **kwargs):
        start = timeit.default_timer()
        res = function_to_time(*args, **kwargs)
        end = timeit.default_timer()
        runtime = end - start

        hours, rem = divmod(runtime, 3600)
        minutes, rem = divmod(rem, 60)
        seconds, milliseconds = divmod(rem * 1000, 1000)
        _, nanoseconds = divmod(milliseconds * 1000, 1000)

        time_parts = []
        if hours > 0:
            time_parts.append(f"{int(hours)} hours")
        if minutes > 0:
            time_parts.append(f"{int(minutes)} minutes")
        if seconds > 0:
            time_parts.append(f"{int(seconds)} seconds")
        if milliseconds > 0:
            time_parts.append(f"{int(milliseconds)} ms")
        if nanoseconds > 0:
            time_parts.append(f"{int(nanoseconds)} ns")

        time_str = " ".join(time_parts)
        msg = f"{function_to_time.__name__}() took {time_str}"
        print(msg)
        if self.logger:
            self.logger.info(msg)
        return res
