# Logic Pre-Training Language Models
This is the code for our paper "Logic Pre-Training Language Models".



#### Environment

- python=3.6
- pytorch=1.6.0
- dgl=0.6.1
- transformers=4.3.2



#### How to run?

Firstly, there is a data preprocessing process for English wiki dataset.

run the following code in `wiki_preprocess` folder:

```bash
python process_wiki.py
python data_post_process.py
```

To do pre-training, one should run 

```bash
python train_bert_en_auto_vanilla.py
```

The parameters are configed in the original setting. And the pre-trained model is stored in folder `checkpoints`.

Finally, to do finetuning on GLUE dataset, one should config the path to the pre-trained model, and run the following code:

```bash
python finetune_GLUE.py
```

The test results are stored in the path `test_outputs/glue/xx` where `xx` is the task name.
